/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.event;

import com.qqt.platform.common.dto.LogErrorDTO;
import com.qqt.platform.common.event.ErrorLogEvent;
import com.qqt.platform.common.utils.Exceptions;
import com.qqt.platform.common.utils.LogAbstractUtil;
import com.qqt.platform.common.utils.SpringUtils;
import com.qqt.platform.common.utils.WebUtil;
import java.util.HashMap;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ErrorLogPublisher {
    public static void publishEvent(Throwable error, LogErrorDTO logError) {
        HttpServletRequest request = WebUtil.getRequest();
        if (!Objects.isNull(error)) {
            String tmp = Exceptions.getStackTraceAsString(error);
            tmp = StringUtils.isEmpty((Object)tmp) ? "" : tmp.substring(0, tmp.length() > 1024 ? 1024 : tmp.length());
            logError.setStackTrace(tmp);
            logError.setExceptionName(error.getClass().getName());
            logError.setMessage(error.getMessage());
            Object[] elements = error.getStackTrace();
            if (!ObjectUtils.isEmpty((Object[])elements)) {
                Object element = elements[0];
                logError.setMethodName(((StackTraceElement)element).getMethodName());
                logError.setMethodClass(((StackTraceElement)element).getClassName());
                logError.setFileName(((StackTraceElement)element).getFileName());
                logError.setLineNumber(((StackTraceElement)element).getLineNumber());
            }
        }
        LogAbstractUtil.addRequestInfoToLog(request, logError);
        HashMap<String, Object> event = new HashMap<String, Object>(16);
        event.put("info", logError);
        SpringUtils.publishEvent(new ErrorLogEvent(event));
    }
}

