/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.facade.mapper;

import com.qqt.platform.common.domain.AbstractCompanyEntity;
import com.qqt.platform.common.domain.IAuditingEntity;
import com.qqt.platform.common.dto.CompanyDO;
import com.qqt.platform.common.dto.UserDetailDO;
import com.qqt.platform.common.feign.AdminFeignService;
import com.qqt.platform.common.service.dto.AbstractAuditingDTO;
import com.qqt.platform.common.utils.AdminEntityCacheUtils;
import com.qqt.platform.common.utils.JCacheManagerUtils;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.AfterMapping;
import org.mapstruct.MappingTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AuditingDTOMapper<DTO extends AbstractAuditingDTO, Entity extends IAuditingEntity> {
    private static final Logger logger = LoggerFactory.getLogger(AuditingDTOMapper.class);
    @Autowired
    JCacheManagerUtils jCacheManagerUtils;
    @Autowired
    private AdminFeignService adminFeignService;
    @Autowired
    private AdminEntityCacheUtils adminEntityCacheUtils;

    public abstract Entity toEntity(DTO var1);

    @AfterMapping
    protected void fillAuditing(Entity auditingEntity, @MappingTarget DTO auditingDTO) {
        UserDetailDO userDetailDO;
        String createdBy = auditingEntity.getCreatedBy();
        ((AbstractAuditingDTO)auditingDTO).setCreatedName(createdBy);
        String lastModifiedBy = auditingEntity.getLastModifiedBy();
        ((AbstractAuditingDTO)auditingDTO).setLastModifiedName(lastModifiedBy);
        Boolean lastModifiedSetted = Boolean.FALSE;
        try {
            if (StringUtils.isNumeric((CharSequence)createdBy) && (userDetailDO = this.adminEntityCacheUtils.getUserDO(Long.parseLong(createdBy))) != null) {
                ((AbstractAuditingDTO)auditingDTO).setCreatedName(userDetailDO.getNameCn());
                if (StringUtils.isNumeric((CharSequence)lastModifiedBy) && lastModifiedBy.equals(createdBy)) {
                    ((AbstractAuditingDTO)auditingDTO).setLastModifiedName(userDetailDO.getNameCn());
                    lastModifiedSetted = Boolean.TRUE;
                }
            }
        }
        catch (Exception e) {
            logger.error("getUserDetailByCode CreatedBy error,auditingDTO:{},error:{}", auditingDTO, (Object)e);
        }
        if (!lastModifiedSetted.booleanValue()) {
            try {
                if (StringUtils.isNumeric((CharSequence)lastModifiedBy) && (userDetailDO = this.adminEntityCacheUtils.getUserDO(Long.parseLong(lastModifiedBy))) != null) {
                    ((AbstractAuditingDTO)auditingDTO).setLastModifiedName(userDetailDO.getNameCn());
                }
            }
            catch (Exception e) {
                logger.error("getUserDetailByCode LastModifiedBy error,auditingDTO:{},error:{}", auditingDTO, (Object)e);
            }
        }
        Long companyId = null;
        if (auditingEntity instanceof AbstractCompanyEntity) {
            AbstractCompanyEntity companyEntity = (AbstractCompanyEntity)auditingEntity;
            if (companyEntity.getCompanyId() != null && companyEntity.getCompanyId() > 0L) {
                companyId = companyEntity.getCompanyId();
            }
        } else if (null != ((AbstractAuditingDTO)auditingDTO).getCompanyId()) {
            companyId = ((AbstractAuditingDTO)auditingDTO).getCompanyId();
        }
        if (null != companyId) {
            try {
                CompanyDO companyDO = this.adminEntityCacheUtils.getCompanyDO(companyId);
                if (companyDO != null) {
                    ((AbstractAuditingDTO)auditingDTO).setCompanyId(companyDO.getId());
                    ((AbstractAuditingDTO)auditingDTO).setCompanyCode(companyDO.getCode());
                    ((AbstractAuditingDTO)auditingDTO).setCompanyName(companyDO.getName());
                }
            }
            catch (Exception e) {
                logger.error("getCompanyById error,auditingDTO:{},error:{}", auditingDTO, (Object)e);
            }
        }
    }

    public abstract DTO toDto(Entity var1);

    public abstract List<Entity> toEntity(List<DTO> var1);

    public abstract List<DTO> toDto(List<Entity> var1);

    public abstract List<DTO> toDto(Set<Entity> var1);
}

