/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.service;

import com.qqt.platform.common.service.FormNoSerialUtil;
import com.qqt.platform.common.service.FormNoTypeEnum;
import com.qqt.platform.common.utils.SnowflakeIdWorker;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class SerialNumberGeneratorService {
    private final Logger logger = LoggerFactory.getLogger(SerialNumberGeneratorService.class);
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private RedisTemplate redisTemplate;

    public String generateSerialNumber(String prefixString) {
        try {
            return prefixString + this.snowflakeIdWorker.nextId();
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
            return "";
        }
    }

    public String generateSerialNumber(FormNoTypeEnum formNoTypeEnum) {
        return this.generateSerialNumber(formNoTypeEnum.getPrefix(), formNoTypeEnum.getDatePattern(), formNoTypeEnum.getSerialLength());
    }

    public String generateSerialNumber(String prefix, String datePattern, Integer serialLength) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(datePattern);
            StringBuffer sb = new StringBuffer();
            sb.append(prefix);
            sb.append(formatter.format(LocalDateTime.now()));
            String formNoPrefix = sb.toString();
            Long incrementalSerial = 1L;
            try {
                incrementalSerial = this.redisTemplate.getConnectionFactory().getConnection().incr(this.redisTemplate.getKeySerializer().serialize((Object)prefix));
                if (incrementalSerial != null && incrementalSerial == 1L) {
                    LocalDateTime now = LocalDateTime.now();
                    LocalDate tomorrow = now.toLocalDate().plusDays(1L);
                    LocalDateTime last = tomorrow.atTime(0, 0, 0, 0);
                    long end = last.toInstant(ZoneOffset.UTC).toEpochMilli();
                    long start = now.toInstant(ZoneOffset.UTC).toEpochMilli();
                    long timeout = end - start;
                    this.redisTemplate.expire((Object)prefix, timeout, TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception e) {
                this.logger.error("generateSequenceNumber error\uff1a", (Throwable)e);
            }
            String serialWithPrefix = FormNoSerialUtil.completionSerial(formNoPrefix, incrementalSerial, serialLength);
            return serialWithPrefix;
        }
        catch (Exception ex) {
            this.logger.error("generateSequenceNumber error\uff1a", (Throwable)ex);
            return "";
        }
    }
}

