/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalQuery;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static final String PATTERN_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_DATE = "yyyy-MM-dd";
    public static final String PATTERN_TIME = "HH:mm:ss";
    public static final DateTimeFormatter DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss");
    static final TemporalQuery<Instant> INSTANT_QUERY = temporal -> Instant.from(temporal);

    public static Date now() {
        return new Date();
    }

    public static Date plus(Date date, TemporalAmount amount) {
        Instant instant = date.toInstant();
        return Date.from(instant.plus(amount));
    }

    public static String format(TemporalAccessor temporal, String pattern) {
        return DateTimeFormatter.ofPattern(pattern).format(temporal);
    }

    public static <T> T parse(String dateStr, String pattern, TemporalQuery<T> query) {
        return DateTimeFormatter.ofPattern(pattern).parse((CharSequence)dateStr, query);
    }

    public static Instant toInstant(LocalDateTime dateTime) {
        return dateTime.atZone(ZoneId.systemDefault()).toInstant();
    }

    public static Date toDate(LocalDateTime dateTime) {
        return Date.from(DateUtil.toInstant(dateTime));
    }

    public static Date toDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static Duration between(Temporal startInclusive, Temporal endExclusive) {
        return Duration.between(startInclusive, endExclusive);
    }

    public static Period between(LocalDate startDate, LocalDate endDate) {
        return Period.between(startDate, endDate);
    }

    public static Duration between(Date startDate, Date endDate) {
        return Duration.between(startDate.toInstant(), endDate.toInstant());
    }

    public static Integer getCurrentYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(1);
    }

    public static Integer getCurrentYearAndMonth() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2);
        if (month <= 9) {
            return Integer.parseInt(year + "0" + month);
        }
        return Integer.parseInt(year + "" + month);
    }

    public static Instant parse(String dateTime, String pattern) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        try {
            Date date = simpleDateFormat.parse(dateTime);
            return date.toInstant();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Instant[] getLastWeek() {
        Date now = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(now);
        c.add(5, -7);
        Date end = c.getTime();
        Instant[] instants = new Instant[2];
        instants[1] = Instant.ofEpochMilli(now.getTime());
        instants[0] = Instant.ofEpochMilli(end.getTime());
        return instants;
    }

    public static Instant[] getLastMonth() {
        Date now = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(now);
        c.add(2, -1);
        Date end = c.getTime();
        Instant[] instants = new Instant[2];
        instants[1] = Instant.ofEpochMilli(now.getTime());
        instants[0] = Instant.ofEpochMilli(end.getTime());
        return instants;
    }

    public static Instant[] getLastYear() {
        Date now = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(now);
        c.add(1, -1);
        Date end = c.getTime();
        Instant[] instants = new Instant[2];
        instants[1] = Instant.ofEpochMilli(now.getTime());
        instants[0] = Instant.ofEpochMilli(end.getTime());
        return instants;
    }

    public static Date[] getDateRange(String type) {
        Date endDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        if (!"DAY".equals(type)) {
            if ("WEEK".equals(type)) {
                calendar.set(7, 1);
            } else if ("MONTH".equals(type)) {
                calendar.set(5, 1);
            } else if ("YEAR".equals(type)) {
                calendar.set(2, 0);
                calendar.set(5, 1);
            }
        }
        Date startDate = calendar.getTime();
        return new Date[]{startDate, endDate};
    }
}

