/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.springframework.util.StringUtils;

public class NetUtil {
    public static final String LOCAL_HOST = "127.0.0.1";

    public static String getHostName() {
        String hostname;
        try {
            InetAddress address = InetAddress.getLocalHost();
            hostname = address.getHostName();
            if (StringUtils.isEmpty((Object)hostname)) {
                hostname = address.toString();
            }
        }
        catch (UnknownHostException ignore) {
            hostname = LOCAL_HOST;
        }
        return hostname;
    }

    public static String getHostIp() {
        String hostAddress;
        try {
            InetAddress address = NetUtil.getLocalHostLANAddress();
            hostAddress = address.getHostAddress();
            if (StringUtils.isEmpty((Object)hostAddress)) {
                hostAddress = address.toString();
            }
        }
        catch (UnknownHostException ignore) {
            hostAddress = LOCAL_HOST;
        }
        return hostAddress;
    }

    private static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean tryPort(int port) {
        try (ServerSocket ignore = new ServerSocket(port);){
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }
}

