/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.client;

import com.qqt.platform.common.security.SecurityUtils;
import com.qqt.platform.common.utils.ThreadLocalUtil;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class WorkflowFeignClientInterceptor
implements RequestInterceptor {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER = "Bearer";
    @Autowired
    private StringRedisTemplate redisTemplate;

    public void apply(RequestTemplate template) {
        String tags = (String)ThreadLocalUtil.get("gray");
        if (StringUtils.isEmpty((Object)tags)) {
            template.header("gray", new String[]{tags});
        }
        String workflowTokenComplete = (String)this.redisTemplate.opsForValue().get((Object)"workflow_token_");
        String workflowTokenComplete1 = (String)this.redisTemplate.opsForValue().get((Object)"workflow_schedule_token_");
        if (workflowTokenComplete != null || workflowTokenComplete1 != null) {
            template.header(AUTHORIZATION_HEADER, new String[]{String.format("%s %s", BEARER, workflowTokenComplete == null ? workflowTokenComplete1 : workflowTokenComplete)});
        } else {
            SecurityUtils.getCurrentUserJWT().ifPresent(s -> template.header(AUTHORIZATION_HEADER, new String[]{String.format("%s %s", BEARER, s)}));
        }
    }
}

