/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.qqt.platform.common.dto.AddressDO;
import com.qqt.platform.common.dto.CityDO;
import com.qqt.platform.common.dto.CompanyDO;
import com.qqt.platform.common.dto.CountryDO;
import com.qqt.platform.common.dto.DistrictDO;
import com.qqt.platform.common.dto.ProvinceDO;
import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.dto.SiteDO;
import com.qqt.platform.common.dto.StoreDO;
import com.qqt.platform.common.dto.UserDetailDO;
import com.qqt.platform.common.dto.UserGroupDO;
import com.qqt.platform.common.feign.AdminFeignService;
import com.qqt.platform.common.utils.EntityCacheUtils;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class AdminEntityCacheUtils {
    public static final String COMPANY_CLASS = "com.qqt.platform.admin.domain.Company";
    public static final String USER_CLASS = "com.qqt.platform.admin.domain.User";
    public static final String SITE_CLASS = "com.qqt.platform.admin.domain.Site";
    public static final String STORE_CLASS = "com.qqt.platform.admin.domain.Store";
    public static final String USERGROUP_CLASS = "com.qqt.platform.admin.domain.UserGroup";
    public static final String ADDRESS_CLASS = "com.qqt.platform.admin.domain.Address";
    public static final String COUNTRY_CLASS = "com.qqt.platform.admin.domain.Country";
    public static final String PROVINCE_CLASS = "com.qqt.platform.admin.domain.Province";
    public static final String CITY_CLASS = "com.qqt.platform.admin.domain.City";
    public static final String DISTRICT_CLASS = "com.qqt.platform.admin.domain.District";
    @Autowired
    private EntityCacheUtils entityCacheUtils;
    @Autowired
    private AdminFeignService adminFeignService;
    @Autowired
    private ObjectMapper objectMapper;

    public CompanyDO getCompanyDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        Map map = this.entityCacheUtils.getFromCache(COMPANY_CLASS, id);
        if (map == null) {
            ResponseEntity<ResultDTO<CompanyDO>> companyResp = this.adminFeignService.getCompanyById(id, new String[0]);
            if (companyResp != null && companyResp.getBody() != null && ((ResultDTO)companyResp.getBody()).isSuccess()) {
                return (CompanyDO)((ResultDTO)companyResp.getBody()).getData();
            }
        } else {
            return (CompanyDO)this.objectMapper.convertValue((Object)map, CompanyDO.class);
        }
        return null;
    }

    public UserDetailDO getUserDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        Map map = this.entityCacheUtils.getFromCache(USER_CLASS, id);
        if (map == null) {
            ResponseEntity<ResultDTO<UserDetailDO>> responseEntity = this.adminFeignService.getUserDetailById(id, new String[]{"basic"});
            if (responseEntity != null && responseEntity.getBody() != null && ((ResultDTO)responseEntity.getBody()).isSuccess()) {
                return (UserDetailDO)((ResultDTO)responseEntity.getBody()).getData();
            }
        } else {
            map.put("companyId", map.get("company"));
            return (UserDetailDO)this.objectMapper.convertValue((Object)map, UserDetailDO.class);
        }
        return null;
    }

    public SiteDO getSiteDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        Map map = this.entityCacheUtils.getFromCache(SITE_CLASS, id);
        if (map == null) {
            ResponseEntity<SiteDO> responseEntity = this.adminFeignService.getSiteDO(id);
            if (responseEntity != null && responseEntity.getBody() != null) {
                return (SiteDO)responseEntity.getBody();
            }
        } else {
            map.put("companyId", map.get("company"));
            return (SiteDO)this.objectMapper.convertValue((Object)map, SiteDO.class);
        }
        return null;
    }

    public StoreDO getStoreDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        Map map = this.entityCacheUtils.getFromCache(STORE_CLASS, id);
        if (map == null) {
            ResponseEntity<StoreDO> responseEntity = this.adminFeignService.getStoreDO(id);
            if (responseEntity != null && responseEntity.getBody() != null) {
                return (StoreDO)responseEntity.getBody();
            }
        } else {
            map.put("companyId", map.get("company"));
            map.put("siteId", map.get("site"));
            return (StoreDO)this.objectMapper.convertValue((Object)map, StoreDO.class);
        }
        return null;
    }

    public UserGroupDO getUserGroupDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        Map map = this.entityCacheUtils.getFromCache(USERGROUP_CLASS, id);
        if (map == null) {
            ResponseEntity<UserGroupDO> responseEntity = this.adminFeignService.getUserGroupById(id);
            if (responseEntity != null && responseEntity.getBody() != null) {
                return (UserGroupDO)responseEntity.getBody();
            }
        } else {
            map.put("companyId", map.get("company"));
            map.put("parentId", map.get("parent"));
            return (UserGroupDO)this.objectMapper.convertValue((Object)map, UserGroupDO.class);
        }
        return null;
    }

    public AddressDO getAddressDO(Long companyId, Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        Map map = this.entityCacheUtils.getFromCache(ADDRESS_CLASS, id);
        if (map == null) {
            ResponseEntity<AddressDO> responseEntity = this.adminFeignService.getAddressDO(companyId, id);
            if (responseEntity != null && responseEntity.getBody() != null) {
                return (AddressDO)responseEntity.getBody();
            }
        } else {
            map.put("companyId", map.get("company"));
            map.put("userId", map.get("user"));
            AddressDO addressDO = (AddressDO)this.objectMapper.convertValue((Object)map, AddressDO.class);
            try {
                Long country = (Long)map.get("country");
                Long province = (Long)map.get("province");
                Long city = (Long)map.get("city");
                Long district = (Long)map.get("district");
                Map countryMap = this.entityCacheUtils.getFromCache(COUNTRY_CLASS, country);
                Map provinceMap = this.entityCacheUtils.getFromCache(PROVINCE_CLASS, province);
                Map cityMap = this.entityCacheUtils.getFromCache(CITY_CLASS, city);
                Map districtMap = this.entityCacheUtils.getFromCache(DISTRICT_CLASS, district);
                CountryDO countryDO = (CountryDO)this.objectMapper.convertValue((Object)countryMap, CountryDO.class);
                ProvinceDO provinceDO = (ProvinceDO)this.objectMapper.convertValue((Object)provinceMap, ProvinceDO.class);
                CityDO cityDO = (CityDO)this.objectMapper.convertValue((Object)cityMap, CityDO.class);
                DistrictDO districtDO = (DistrictDO)this.objectMapper.convertValue((Object)districtMap, DistrictDO.class);
                addressDO.setCountryDO(countryDO);
                addressDO.setProvinceDO(provinceDO);
                addressDO.setCityDO(cityDO);
                addressDO.setDistrictDO(districtDO);
                addressDO.setCountryId(country);
                addressDO.setProvinceId(province);
                addressDO.setCityId(city);
                addressDO.setDistrictId(district);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return addressDO;
        }
        return null;
    }
}

