/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.utils;

import cn.hutool.core.util.StrUtil;
import com.aspose.cells.License;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.SaveOptions;
import com.aspose.cells.Workbook;
import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.HtmlConverter;
import com.itextpdf.html2pdf.resolver.font.DefaultFontProvider;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.FontProgramFactory;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.events.IEventHandler;
import com.itextpdf.kernel.events.PdfDocumentEvent;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.property.TextAlignment;
import com.itextpdf.layout.property.VerticalAlignment;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfUtil {
    public static final Logger log = LoggerFactory.getLogger(PdfUtil.class);
    private static final String SHIPPED_FONT_RESOURCE_PATH = Objects.requireNonNull(PdfUtil.class.getResource("/static/msyhl.ttc")).toString();

    public static String htmlToPdf(String fileRootPath, String html, String fileName, boolean water, String waterString, PageSize pageSize) throws Exception {
        File saveDirFile;
        if (fileRootPath == null) {
            fileRootPath = "\\mnt\\soft\\upload";
        }
        if (StrUtil.isBlank((CharSequence)html)) {
            return null;
        }
        if (pageSize == null) {
            pageSize = PageSize.A4;
        }
        if (!(saveDirFile = new File(fileRootPath)).exists()) {
            saveDirFile.mkdirs();
        }
        String filePath = fileRootPath + "/" + fileName + ".pdf";
        PdfWriter pdfWriter = new PdfWriter(new File(fileRootPath + "/", FilenameUtils.getName((String)(fileName + ".pdf"))));
        PdfDocument pdfDocument = new PdfDocument(pdfWriter);
        pdfDocument.setDefaultPageSize(pageSize);
        ConverterProperties pro = new ConverterProperties();
        DefaultFontProvider fontProvider = new DefaultFontProvider();
        FontProgram fontProgram = FontProgramFactory.createFont((String)(SHIPPED_FONT_RESOURCE_PATH + ",0"));
        fontProvider.addFont(fontProgram);
        pro.setFontProvider((FontProvider)fontProvider);
        IEventHandler handlerStartPage = event -> {
            PdfDocumentEvent docEvent = (PdfDocumentEvent)event;
            PdfDocument pdf = docEvent.getDocument();
            PdfPage page = docEvent.getPage();
            PdfCanvas pdfCanvas = new PdfCanvas(page.newContentStreamBefore(), page.getResources(), pdf);
            int height = (int)page.getPageSize().getHeight();
            int width = (int)page.getPageSize().getWidth();
            Rectangle rect = new Rectangle((float)width / 2.0f - 10.0f, 10.0f, 36.0f, 32.0f);
            Canvas canvas = new Canvas(pdfCanvas, rect);
            canvas.add((IBlockElement)new Paragraph(String.valueOf(pdf.getNumberOfPages())).setFontSize(12.0f));
            canvas.showTextAligned("NO.:" + fileName, (float)width - 10.0f, (float)height - 25.0f, TextAlignment.RIGHT);
            canvas.close();
        };
        pdfDocument.addEventHandler("StartPdfPage", handlerStartPage);
        if (water) {
            IEventHandler handlerEndPage = event -> {
                PdfDocumentEvent docEvent = (PdfDocumentEvent)event;
                PdfDocument pdf = docEvent.getDocument();
                PdfPage page = docEvent.getPage();
                PdfCanvas pdfCanvas = new PdfCanvas(page.newContentStreamBefore(), page.getResources(), pdf);
                PdfFont font = null;
                font = PdfFontFactory.createFont((FontProgram)fontProgram, (String)"UTF-8", (boolean)true);
                ((Canvas)((Canvas)((Canvas)((Canvas)new Canvas(pdfCanvas, pdf, page.getPageSize()).setFontSize(36.0f)).setOpacity(Float.valueOf(0.2f))).setFont(font)).setFontColor((Color)new DeviceRgb(255, 0, 0))).showTextAligned(new Paragraph(waterString), 298.0f, 421.0f, pdf.getPageNumber(page), TextAlignment.CENTER, VerticalAlignment.MIDDLE, 45.0f);
            };
            pdfDocument.addEventHandler("EndPdfPage", handlerEndPage);
        }
        HtmlConverter.convertToPdf((String)html.replaceAll("\u21b5", ""), (PdfDocument)pdfDocument, (ConverterProperties)pro);
        return filePath;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    public static String changeTemplate(String html) {
        String head = html.substring(0, html.indexOf("</tr>") + 5);
        String center = html.substring(html.indexOf("</tr>") + 5, html.lastIndexOf("</tr>") + 5);
        String last = html.substring(html.lastIndexOf("</tr>") + 5, html.length());
        StringBuilder newHtml = new StringBuilder();
        newHtml.append(head).append("<#list itemList as item>").append(center).append("</#list>").append(last);
        return newHtml.toString();
    }

    private static boolean getLicense() {
        boolean result = false;
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("static/xlsxlicense.xml");
            License license = new License();
            license.setLicense(is);
            result = true;
        }
        catch (Exception e) {
            log.error("error license:" + e.getMessage());
        }
        return result;
    }

    public static void excel2pdf(String excelPath, String pdfPath) {
        if (!PdfUtil.getLicense()) {
            return;
        }
        try {
            FileInputStream is = new FileInputStream(new File(excelPath));
            Workbook wb = new Workbook((InputStream)is);
            PdfSaveOptions options = new PdfSaveOptions();
            options.setMergeAreas(true);
            wb.save(pdfPath, (SaveOptions)options);
            ((InputStream)is).close();
        }
        catch (Exception e) {
            log.error("error excel2pdf:" + e.getMessage());
        }
    }

    public static void excel2pdf(String excelPath, HttpServletResponse response) {
        if (!PdfUtil.getLicense()) {
            return;
        }
        try {
            File file = new File(excelPath);
            FileInputStream is = new FileInputStream(new File(excelPath));
            Workbook wb = new Workbook((InputStream)is);
            PdfSaveOptions options = new PdfSaveOptions();
            options.setMergeAreas(true);
            wb.save((OutputStream)response.getOutputStream(), (SaveOptions)options);
            ((InputStream)is).close();
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            log.error("error excel2pdf:" + e.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        String html = "<h4>${zh_index}\u3001\u7269\u6599\u6e05\u5355\u5217\u8868</h4>\r\n<table style=\"border-collapse: collapse; width: 99.1736%; height: 40px;\" border=\"1\">\r\n<tbody>\r\n<tr style=\"height: 20px;\">\r\n<td style=\"width: 14.1393%; height: 20px;\">\u7269\u6599\u7f16\u7801</td>\r\n<td style=\"width: 19.5447%; height: 20px;\">\u7269\u6599\u63cf\u8ff0</td>\r\n<td style=\"width: 26.9996%; height: 20px;\">\u89c4\u683c</td>\r\n<td style=\"width: 12.8286%; height: 20px;\">\u6570\u91cf</td>\r\n<td style=\"width: 11.6599%; height: 20px;\">\u5355\u4ef7</td>\r\n<td style=\"width: 11.2216%; height: 20px;\">\u91d1\u989d</td>\r\n</tr>\r\n<tr style=\"height: 20px;\">\r\n<td style=\"width: 14.1393%; height: 20px;\">${(item.materialCode)!''}</td>\r\n<td style=\"width: 19.5447%; height: 20px;\">${(item.materialDesc)!''}</td>\r\n<td style=\"width: 26.9996%; height: 20px;\">${(item.materialSpec)!''}</td>\r\n<td style=\"width: 12.8286%; height: 20px;\">${(item.quantity)!''}</td>\r\n<td style=\"width: 11.6599%; height: 20px;\">${(item.price)!''}</td>\r\n<td style=\"width: 11.2216%; height: 20px;\">${(item.taxAmount)!''}</td>\r\n</tr>\r\n</tbody>\r\n</table>";
        String head = html.substring(0, html.indexOf("</tr>") + 5);
        System.out.println(head);
        System.out.println("----------------------------------------");
        String center = html.substring(html.indexOf("</tr>") + 5, html.lastIndexOf("</tr>") + 5);
        System.out.println(center);
        System.out.println("----------------------------------------");
        String last = html.substring(html.lastIndexOf("</tr>") + 5, html.length());
        System.out.println(last);
        System.out.println("----------------------------------------");
        StringBuilder newHtml = new StringBuilder();
        newHtml.append(head).append("<#list itemList as item>").append(center).append("</#list>").append(last);
        System.out.println(newHtml);
        System.out.println(html.indexOf("</tr>"));
        html = PdfUtil.changeTemplate(html);
        PdfUtil.htmlToPdf(null, html, "CN200901901", true, "qqt", PageSize.A4);
    }
}

