/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.aop;

import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.enumeration.ErrorEnum;
import com.qqt.platform.common.exception.MultiVerifyException;
import com.qqt.platform.common.utils.ResultUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@Order(value=1)
@RestControllerAdvice
public class GlobalExceptionHandlerAdvice {
    private final Logger log = LoggerFactory.getLogger(GlobalExceptionHandlerAdvice.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResultDTO validParamHandler(MethodArgumentNotValidException e) {
        this.log.error("@Valid \u6821\u9a8c\u5f02\u5e38\u5904\u7406:{}", (Throwable)e);
        BindingResult bindingResult = e.getBindingResult();
        return this.fillResultDTO(bindingResult);
    }

    @ExceptionHandler(value={BindException.class})
    public ResultDTO validParamHandler(BindException e) {
        this.log.error("@Valid BindException\u6821\u9a8c\u5f02\u5e38\u5904\u7406:{}", (Throwable)e);
        BindingResult bindingResult = e.getBindingResult();
        return this.fillResultDTO(bindingResult);
    }

    @ExceptionHandler(value={MultiVerifyException.class})
    public ResultDTO validParamHandler(MultiVerifyException e) {
        this.log.error("\u81ea\u5b9a\u4e49\u591a\u5b57\u6bb5\u5f02\u5e38:{}", (Throwable)e);
        Map<String, Object> fieldErrors = e.getFieldErrors();
        return ResultUtil.fail(e.getCode(), fieldErrors, ErrorEnum.VERIFY_PARAMS_1102.getErrMsg());
    }

    private ResultDTO fillResultDTO(BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            HashMap errors = new HashMap();
            bindingResult.getAllErrors().forEach(error -> {
                FieldError fieldError = (FieldError)error;
                errors.put(fieldError.getField(), fieldError.getDefaultMessage());
            });
            return ResultUtil.fail(Integer.parseInt(ErrorEnum.VALID_PARAMS_1101.getErrCode()), errors, ErrorEnum.VALID_PARAMS_1101.getErrMsg());
        }
        return ResultUtil.fail(Integer.parseInt(ErrorEnum.VALID_PARAMS_1101.getErrCode()), ErrorEnum.VALID_PARAMS_1101.getErrMsg());
    }
}

