/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.cache.config;

import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.qqt.platform.common.aop.MapperCache;
import com.qqt.platform.common.cache.TwoCache;
import com.qqt.platform.common.cache.config.MapperCacheMapping;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
public class MapperCacheAutoConfig
implements InitializingBean {
    private final Logger log = LoggerFactory.getLogger(MapperCacheAutoConfig.class);
    @Autowired
    private SqlSessionFactory sqlSessionFactory;

    @Bean
    public MapperCacheMapping mapperCacheMapping() {
        return new MapperCacheMapping();
    }

    public void afterPropertiesSet() throws Exception {
        Set<Class<?>> allBeanClassForMapperCache;
        MybatisConfiguration configuration = (MybatisConfiguration)this.sqlSessionFactory.getConfiguration();
        Collection classes = configuration.getMapperRegistry().getMappers();
        if (!CollectionUtils.isEmpty((Collection)classes) && !CollectionUtils.isEmpty(allBeanClassForMapperCache = this.getAllBeanClassForMapperCache(classes))) {
            MapperCacheMapping mapperCacheMapping = this.mapperCacheMapping();
            allBeanClassForMapperCache.forEach(clazz -> {
                MapperCache annotation = clazz.getAnnotation(MapperCache.class);
                Class<? extends TwoCache> type = annotation.type();
                try {
                    TwoCache twoCache = type.newInstance();
                    twoCache.setParams(clazz.getName(), annotation.size(), annotation.flushInterval(), annotation.eviction());
                    mapperCacheMapping.addMapping(clazz.getName(), twoCache);
                }
                catch (Exception e) {
                    this.log.error("\u53cd\u5c04\u5b9e\u4f8b\u5316TwoCache\u5f02\u5e38:{}", (Throwable)e);
                    try {
                        throw e;
                    }
                    catch (InstantiationException instantiationException) {
                        instantiationException.printStackTrace();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                }
            });
        }
    }

    private Set<Class<?>> getAllBeanClassForMapperCache(Collection<Class<?>> classes) {
        return classes.stream().filter(x -> x.isAnnotationPresent(MapperCache.class)).filter(x -> {
            MapperCache annotation = x.getAnnotation(MapperCache.class);
            return annotation.type() != null;
        }).collect(Collectors.toSet());
    }
}

