/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.cache.impl;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.qqt.platform.common.cache.TwoCache;
import com.qqt.platform.common.component.SpringUtils;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.redisson.api.EvictionMode;
import org.redisson.api.RMapCache;
import org.redisson.api.RedissonClient;

public class RedissonTwoCache
implements TwoCache {
    private String id;
    private Integer size;
    private Long flushInterval = 0L;
    private String eviction;
    protected static ConcurrentHashMap<String, RMapCache<Object, Object>> mapCacheMap = new ConcurrentHashMap();

    @Override
    public void setParams(String id, Integer size, Long flushInterval, String eviction) {
        this.id = id;
        this.size = size;
        this.flushInterval = flushInterval;
        this.eviction = eviction;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void putObject(Object o, Object o1) {
        RMapCache<Object, Object> mapCache = this.checkRMapCache();
        if (ObjectUtils.isEmpty((Object)o1)) {
            mapCache.remove(o);
        } else if (!(o1 instanceof Optional)) {
            mapCache.put(o, o1, this.flushInterval.longValue(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public Object getObject(Object o) {
        RMapCache<Object, Object> mapCache = this.checkRMapCache();
        return mapCache.get(o);
    }

    @Override
    public Object removeObject(Object o) {
        RMapCache<Object, Object> mapCache = this.checkRMapCache();
        return mapCache.remove(o);
    }

    @Override
    public void clear() {
        RMapCache<Object, Object> mapCache = this.checkRMapCache();
        mapCache.clear();
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Integer getSize() {
        return this.size;
    }

    public Long getFlushInterval() {
        return this.flushInterval;
    }

    public void setFlushInterval(Long flushInterval) {
        this.flushInterval = flushInterval;
    }

    public String getEviction() {
        return this.eviction;
    }

    public void setEviction(String eviction) {
        this.eviction = eviction;
    }

    protected RMapCache<Object, Object> getMapCache(String id, RedissonClient redisson) {
        return redisson.getMapCache(id);
    }

    private RMapCache<Object, Object> checkRMapCache() {
        if (mapCacheMap.containsKey(this.getId())) {
            return mapCacheMap.get(this.getId());
        }
        RedissonClient redisson = this.getInstance();
        RMapCache<Object, Object> mapCache = this.getMapCache(this.id, redisson);
        mapCache.setMaxSize(this.size == null || this.size < 0 ? 1024 : this.size, RedissonTwoCache.getEvictionMode(this.eviction));
        mapCacheMap.put(this.getId(), mapCache);
        return mapCache;
    }

    private RedissonClient getInstance() {
        RedissonClient redisson = (RedissonClient)SpringUtils.getBean("redisson");
        if (redisson == null) {
            throw new IllegalStateException("Redisson config is not defined");
        }
        return redisson;
    }

    public static EvictionMode getEvictionMode(String code) {
        for (EvictionMode mode : EvictionMode.values()) {
            if (!mode.name().equalsIgnoreCase(code)) continue;
            return mode;
        }
        return EvictionMode.LRU;
    }
}

