/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.client;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.qqt.platform.common.security.SecurityUtils;
import com.qqt.platform.common.utils.ThreadLocalUtil;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class CommonFeignClientInterceptor
implements RequestInterceptor {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER = "Bearer";

    public void apply(RequestTemplate template) {
        Optional<String> optional;
        String tags = (String)ThreadLocalUtil.get("gray");
        if (StringUtils.isEmpty((Object)tags)) {
            template.header("gray", new String[]{tags});
        }
        if ((optional = SecurityUtils.getCurrentUserJWT()).isPresent()) {
            template.header(AUTHORIZATION_HEADER, new String[]{String.format("%s %s", BEARER, optional.get())});
        } else {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (attributes != null) {
                HttpServletRequest request = attributes.getRequest();
                String token = request.getHeader(AUTHORIZATION_HEADER);
                template.header(AUTHORIZATION_HEADER, new String[]{token});
            } else {
                JSONObject json;
                String token;
                Object object;
                String requestBody;
                Optional options;
                Collection list;
                Map objects = template.request().headers();
                if (!CollectionUtil.isEmpty((Map)objects) && !CollectionUtil.isEmpty((Collection)(list = (Collection)objects.get(AUTHORIZATION_HEADER))) && (options = list.stream().findFirst()).isPresent()) {
                    template.header(AUTHORIZATION_HEADER, new String[]{(String)options.get()});
                }
                if ((template.headers().isEmpty() || ((Collection)template.headers().get(AUTHORIZATION_HEADER)).isEmpty()) && template.body() != null && !StringUtils.isEmpty((Object)(requestBody = template.body().toString())) && (object = JSONObject.parse((String)requestBody)) instanceof JSONObject && !StringUtils.isEmpty((Object)(token = (json = (JSONObject)object).getString("token")))) {
                    template.header(AUTHORIZATION_HEADER, new String[]{token});
                }
            }
        }
    }
}

