/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.component;

import cn.hutool.core.util.RandomUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.qqt.platform.common.dto.AddressDO;
import com.qqt.platform.common.dto.CompanyDO;
import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.dto.SiteDO;
import com.qqt.platform.common.dto.StoreDO;
import com.qqt.platform.common.dto.UserDetailDO;
import com.qqt.platform.common.dto.UserGroupDO;
import com.qqt.platform.common.dto.UserSimpleDO;
import com.qqt.platform.common.feign.AdminFeignService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class AdminEntityCacheUtils {
    public static final String USER_NAME = UserSimpleDO.class.getSimpleName() + ":";
    public static final long EXPIRE_TIME = 1380L;
    @Resource(name="redisTemplateForJson")
    private RedisTemplate<String, Object> redisTemplateForJson;
    @Autowired
    private AdminFeignService adminFeignService;
    @Autowired
    private ObjectMapper objectMapper;

    public CompanyDO getCompanyDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        BoundHashOperations hashOperations = this.redisTemplateForJson.boundHashOps((Object)CompanyDO.class.getSimpleName());
        Object map = hashOperations.get((Object)(id + ""));
        if (map == null) {
            ResponseEntity<ResultDTO<CompanyDO>> companyResp = this.adminFeignService.getCompanyById(id, new String[0]);
            if (companyResp != null && companyResp.getBody() != null && ((ResultDTO)companyResp.getBody()).getSuccess().booleanValue()) {
                CompanyDO companyDO = (CompanyDO)((ResultDTO)companyResp.getBody()).getData();
                hashOperations.put((Object)(id + ""), (Object)companyDO);
                this.setHashExpireTime((BoundHashOperations<String, String, Object>)hashOperations);
                return companyDO;
            }
        } else {
            return (CompanyDO)this.objectMapper.convertValue(map, CompanyDO.class);
        }
        return null;
    }

    public UserDetailDO getUserDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        BoundHashOperations hashOperations = this.redisTemplateForJson.boundHashOps((Object)UserDetailDO.class.getSimpleName());
        Object map = hashOperations.get((Object)(id + ""));
        if (map == null) {
            ResponseEntity<ResultDTO<UserDetailDO>> responseEntity = this.adminFeignService.getUserDetailById(id, new String[]{"basic"});
            if (responseEntity != null && responseEntity.getBody() != null && ((ResultDTO)responseEntity.getBody()).getSuccess().booleanValue()) {
                UserDetailDO userDetailDO = (UserDetailDO)((ResultDTO)responseEntity.getBody()).getData();
                hashOperations.put((Object)(id + ""), (Object)userDetailDO);
                this.setHashExpireTime((BoundHashOperations<String, String, Object>)hashOperations);
                return userDetailDO;
            }
        } else {
            return (UserDetailDO)this.objectMapper.convertValue(map, UserDetailDO.class);
        }
        return null;
    }

    public SiteDO getSiteDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        BoundHashOperations hashOperations = this.redisTemplateForJson.boundHashOps((Object)SiteDO.class.getSimpleName());
        Object map = hashOperations.get((Object)(id + ""));
        if (map == null) {
            ResponseEntity<SiteDO> responseEntity = this.adminFeignService.getSiteDO(id);
            if (responseEntity != null && responseEntity.getBody() != null) {
                SiteDO siteDO = (SiteDO)responseEntity.getBody();
                hashOperations.put((Object)(id + ""), (Object)siteDO);
                this.setHashExpireTime((BoundHashOperations<String, String, Object>)hashOperations);
                return siteDO;
            }
        } else {
            return (SiteDO)this.objectMapper.convertValue(map, SiteDO.class);
        }
        return null;
    }

    public StoreDO getStoreDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        BoundHashOperations hashOperations = this.redisTemplateForJson.boundHashOps((Object)StoreDO.class.getSimpleName());
        Object map = hashOperations.get((Object)(id + ""));
        if (map == null) {
            ResponseEntity<StoreDO> responseEntity = this.adminFeignService.getStoreDO(id);
            if (responseEntity != null && responseEntity.getBody() != null) {
                StoreDO storeDO = (StoreDO)responseEntity.getBody();
                hashOperations.put((Object)(id + ""), (Object)storeDO);
                this.setHashExpireTime((BoundHashOperations<String, String, Object>)hashOperations);
                return storeDO;
            }
        } else {
            return (StoreDO)this.objectMapper.convertValue(map, StoreDO.class);
        }
        return null;
    }

    public UserGroupDO getUserGroupDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        BoundHashOperations hashOperations = this.redisTemplateForJson.boundHashOps((Object)UserGroupDO.class.getSimpleName());
        Object map = hashOperations.get((Object)(id + ""));
        if (map == null) {
            ResponseEntity<UserGroupDO> responseEntity = this.adminFeignService.getUserGroupById(id);
            if (responseEntity != null && responseEntity.getBody() != null) {
                UserGroupDO userGroupDO = (UserGroupDO)responseEntity.getBody();
                hashOperations.put((Object)(id + ""), (Object)userGroupDO);
                this.setHashExpireTime((BoundHashOperations<String, String, Object>)hashOperations);
                return userGroupDO;
            }
        } else {
            return (UserGroupDO)this.objectMapper.convertValue(map, UserGroupDO.class);
        }
        return null;
    }

    public AddressDO getAddressDO(Long companyId, Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        BoundHashOperations hashOperations = this.redisTemplateForJson.boundHashOps((Object)AddressDO.class.getSimpleName());
        Object map = hashOperations.get((Object)(id + ""));
        if (map == null) {
            ResponseEntity<AddressDO> responseEntity = this.adminFeignService.getAddressDO(companyId, id);
            if (responseEntity != null && responseEntity.getBody() != null) {
                AddressDO addressDO = (AddressDO)responseEntity.getBody();
                hashOperations.put((Object)(id + ""), (Object)addressDO);
                this.setHashExpireTime((BoundHashOperations<String, String, Object>)hashOperations);
                return addressDO;
            }
        } else {
            return (AddressDO)this.objectMapper.convertValue(map, AddressDO.class);
        }
        return null;
    }

    public AddressDO getAddressDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        BoundHashOperations hashOperations = this.redisTemplateForJson.boundHashOps((Object)AddressDO.class.getSimpleName());
        Object map = hashOperations.get((Object)(id + ""));
        if (map == null) {
            ResponseEntity<AddressDO> responseEntity = this.adminFeignService.getAddressDO(id);
            if (responseEntity != null && responseEntity.getBody() != null) {
                AddressDO addressDO = (AddressDO)responseEntity.getBody();
                hashOperations.put((Object)(id + ""), (Object)addressDO);
                this.setHashExpireTime((BoundHashOperations<String, String, Object>)hashOperations);
                return addressDO;
            }
        } else {
            AddressDO addressDO = (AddressDO)this.objectMapper.convertValue(map, AddressDO.class);
            return addressDO;
        }
        return null;
    }

    public String getUserName(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        Object object = this.redisTemplateForJson.opsForValue().get((Object)(USER_NAME + id));
        if (null == object) {
            ResponseEntity<ResultDTO<UserDetailDO>> responseEntity = this.adminFeignService.getUserDetailById(id, new String[]{"simple"});
            if (responseEntity != null && responseEntity.getBody() != null && ((ResultDTO)responseEntity.getBody()).getSuccess().booleanValue()) {
                UserDetailDO userDetailDO = (UserDetailDO)((ResultDTO)responseEntity.getBody()).getData();
                this.redisTemplateForJson.opsForValue().set((Object)(USER_NAME + id), (Object)userDetailDO.getNameCn(), 1380L + this.getRandomNum(), TimeUnit.MINUTES);
                return userDetailDO.getNameCn();
            }
        } else {
            return object.toString();
        }
        return null;
    }

    private long getRandomNum() {
        return RandomUtil.randomLong((long)60L);
    }

    private void setHashExpireTime(BoundHashOperations<String, String, Object> hashOperations) {
        Long expire = hashOperations.getExpire();
        if (expire == null || expire <= 0L) {
            hashOperations.expire(1380L + this.getRandomNum(), TimeUnit.MINUTES);
        }
    }
}

