/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.component;

import com.qqt.platform.common.component.SpringUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.ibatis.cache.Cache;
import org.redisson.api.EvictionMode;
import org.redisson.api.RMapCache;
import org.redisson.api.RedissonClient;

public class RedissonTwoCacheMyBatis
implements Cache {
    private String id;
    private RMapCache<Object, Object> mapCache;
    private Integer size;
    private Long flushInterval = 0L;
    private String eviction;

    public RedissonTwoCacheMyBatis(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void putObject(Object o, Object o1) {
        this.checkRMapCache();
        if (o1 == null) {
            this.mapCache.remove(o);
        } else {
            this.mapCache.put(o, o1, this.flushInterval.longValue(), TimeUnit.MILLISECONDS);
        }
    }

    public Object getObject(Object o) {
        this.checkRMapCache();
        return this.mapCache.get(o);
    }

    public Object removeObject(Object o) {
        this.checkRMapCache();
        return this.mapCache.remove(o);
    }

    public void clear() {
        this.checkRMapCache();
        this.mapCache.clear();
    }

    public int getSize() {
        this.checkRMapCache();
        return this.mapCache.size();
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Long getFlushInterval() {
        return this.flushInterval;
    }

    public void setFlushInterval(Long flushInterval) {
        this.flushInterval = flushInterval;
    }

    public String getEviction() {
        return this.eviction;
    }

    public void setEviction(String eviction) {
        this.eviction = eviction;
    }

    public ReadWriteLock getReadWriteLock() {
        return null;
    }

    protected RMapCache<Object, Object> getMapCache(String id, RedissonClient redisson) {
        return redisson.getMapCache(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkRMapCache() {
        if (this.mapCache != null) return;
        Class<RedissonTwoCacheMyBatis> clazz = RedissonTwoCacheMyBatis.class;
        synchronized (RedissonTwoCacheMyBatis.class) {
            if (this.mapCache != null) return;
            RedissonClient redisson = this.getInstance();
            this.mapCache = this.getMapCache(this.id, redisson);
            this.mapCache.setMaxSize(this.size == null || this.size < 0 ? 1024 : this.size, RedissonTwoCacheMyBatis.getEvictionMode(this.eviction));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private RedissonClient getInstance() {
        RedissonClient redisson = (RedissonClient)SpringUtils.getBean("redisson");
        if (redisson == null) {
            throw new IllegalStateException("Redisson config is not defined");
        }
        return redisson;
    }

    public static EvictionMode getEvictionMode(String code) {
        for (EvictionMode mode : EvictionMode.values()) {
            if (!mode.name().equalsIgnoreCase(code)) continue;
            return mode;
        }
        return EvictionMode.LRU;
    }
}

