/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.criteria.service;

import com.qqt.platform.common.criteria.Criteria;
import com.qqt.platform.common.criteria.service.QueryWrapperService;
import com.qqt.platform.common.domain.IAuditingEntity;
import com.qqt.platform.common.dto.AbstractAuditingDTO;
import com.qqt.platform.common.facade.mapper.AuditingDTOMapper;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public abstract class CriteriaQueryTemplate<ENTITY extends IAuditingEntity, DTO extends AbstractAuditingDTO>
extends QueryWrapperService<ENTITY, DTO> {
    private final Logger log = LoggerFactory.getLogger(CriteriaQueryTemplate.class);
    protected Class<?> clazz;

    public CriteriaQueryTemplate() {
        ParameterizedType type = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.clazz = (Class)type.getActualTypeArguments()[0];
    }

    protected abstract AuditingDTOMapper<DTO, ENTITY> getBaseModelMapper();

    public List<DTO> findByCriteria(Criteria criteria) {
        this.log.debug(this.clazz.getName() + " findByCriteria criteria:{}", (Object)criteria);
        return this.getBaseModelMapper().toDto(this.getBaseMapper().selectList(this.buildQueryWrapper(criteria)));
    }

    public Page<DTO> findByCriteria(Criteria criteria, Pageable page) {
        this.log.debug(this.clazz.getName() + " findByCriteriaPage criteria:{}", (Object)criteria);
        Page pageResult = this.querySpringPageable(criteria, page);
        return this.buildSpringPageDTO(this.getBaseModelMapper().toDto(pageResult.getContent()), page, pageResult.getTotalElements());
    }

    public com.baomidou.mybatisplus.extension.plugins.pagination.Page<DTO> findMybatisPageByCriteria(Criteria criteria, Pageable page) {
        this.log.debug(this.clazz.getName() + " findMybatisPageByCriteria criteria:{}", (Object)criteria);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page pageResult = this.queryMybatisPageable(criteria, page);
        return this.buildMybatisPageDTO(pageResult, this.getBaseModelMapper().toDto(pageResult.getRecords()));
    }

    public long countByCriteria(Criteria criteria) {
        this.log.debug(this.clazz.getName() + " countByCriteria criteria:{}", (Object)criteria);
        return this.getBaseMapper().selectCount(this.buildQueryWrapper(criteria));
    }
}

