/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.criteria.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.base.CaseFormat;
import com.qqt.platform.common.criteria.Criteria;
import com.qqt.platform.common.criteria.wrapper.QueryCriteriaParser;
import com.qqt.platform.common.criteria.wrapper.QueryWrapperAdapter;
import com.qqt.platform.common.criteria.wrapper.QueryWrapperParam;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.CollectionUtils;

public abstract class QueryWrapperService<ENTITY, DTO> {
    @Autowired
    private QueryCriteriaParser queryCriteriaParser;
    @Autowired
    private QueryWrapperAdapter queryWrapperAdapter;

    protected abstract BaseMapper<ENTITY> getBaseMapper();

    protected QueryWrapper<ENTITY> buildQueryWrapper(Criteria criteria) {
        QueryWrapper queryWrapper = new QueryWrapper();
        this.buildQueryWrapper(queryWrapper, criteria);
        return queryWrapper;
    }

    protected void buildQueryWrapper(QueryWrapper<ENTITY> queryWrapper, Criteria criteria) {
        if (this.isNullParam(queryWrapper, criteria)) {
            return;
        }
        List<QueryWrapperParam> params = this.queryCriteriaParser.parserCriteria(criteria);
        List specifications = params.stream().filter(item -> item.getType().equals((Object)SqlKeyword.AND)).collect(Collectors.toList());
        List ext = params.stream().filter(item -> item.getType().equals((Object)SqlKeyword.OR)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(specifications)) {
            specifications.stream().forEach(queryWrapperParam -> this.queryWrapperAdapter.getQueryWrapperBuilder().get(queryWrapperParam.getCondition()).build(queryWrapper, (QueryWrapperParam)queryWrapperParam));
        }
        if (!CollectionUtils.isEmpty(ext)) {
            queryWrapper.and(wrapper -> ext.stream().forEach(queryWrapperParam -> this.queryWrapperAdapter.getQueryWrapperBuilder().get(queryWrapperParam.getCondition()).build((QueryWrapper<?>)wrapper, (QueryWrapperParam)queryWrapperParam)));
        }
    }

    protected com.baomidou.mybatisplus.extension.plugins.pagination.Page<ENTITY> buildQueryWrapperPageable(QueryWrapper<ENTITY> queryWrapper, Criteria criteria, Pageable pageable) {
        if (this.isNullParam(queryWrapper, criteria)) {
            return null;
        }
        this.buildQueryWrapper(queryWrapper, criteria);
        this.buildQueryWrapperOrderBy(queryWrapper, pageable);
        return new com.baomidou.mybatisplus.extension.plugins.pagination.Page((long)(pageable.getPageNumber() + 1), (long)pageable.getPageSize());
    }

    protected com.baomidou.mybatisplus.extension.plugins.pagination.Page<ENTITY> queryMybatisPageable(Criteria criteria, Pageable pageable) {
        QueryWrapper<ENTITY> queryWrapper = this.buildQueryWrapper(criteria);
        this.buildQueryWrapperOrderBy(queryWrapper, pageable);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page((long)(pageable.getPageNumber() + 1), (long)pageable.getPageSize());
        com.baomidou.mybatisplus.extension.plugins.pagination.Page entityPage = (com.baomidou.mybatisplus.extension.plugins.pagination.Page)this.getBaseMapper().selectPage((IPage)page, queryWrapper);
        return entityPage;
    }

    protected com.baomidou.mybatisplus.extension.plugins.pagination.Page<ENTITY> queryMybatisPageable(QueryWrapper<ENTITY> queryWrapper, Criteria criteria, Pageable pageable) {
        this.buildQueryWrapper(queryWrapper, criteria);
        this.buildQueryWrapperOrderBy(queryWrapper, pageable);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page((long)(pageable.getPageNumber() + 1), (long)pageable.getPageSize());
        com.baomidou.mybatisplus.extension.plugins.pagination.Page entityPage = (com.baomidou.mybatisplus.extension.plugins.pagination.Page)this.getBaseMapper().selectPage((IPage)page, queryWrapper);
        return entityPage;
    }

    protected Page<ENTITY> querySpringPageable(Criteria criteria, Pageable pageable) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<ENTITY> mybatisPage = this.queryMybatisPageable(criteria, pageable);
        return new PageImpl(mybatisPage.getRecords(), pageable, mybatisPage.getTotal());
    }

    protected Page<ENTITY> querySpringPageable(QueryWrapper<ENTITY> queryWrapper, Criteria criteria, Pageable pageable) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<ENTITY> mybatisPage = this.queryMybatisPageable(queryWrapper, criteria, pageable);
        return new PageImpl(mybatisPage.getRecords(), pageable, mybatisPage.getTotal());
    }

    protected com.baomidou.mybatisplus.extension.plugins.pagination.Page<DTO> toPageDTO(long current, long size, long total, List<DTO> data) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page dtoPage = new com.baomidou.mybatisplus.extension.plugins.pagination.Page(current, size, total);
        dtoPage.setRecords(data);
        return dtoPage;
    }

    protected com.baomidou.mybatisplus.extension.plugins.pagination.Page<DTO> buildMybatisPageDTO(com.baomidou.mybatisplus.extension.plugins.pagination.Page<ENTITY> page, List<DTO> data) {
        return this.toPageDTO(page.getCurrent(), page.getSize(), page.getTotal(), data);
    }

    protected Page<DTO> buildSpringPageDTO(List<DTO> data, Pageable pageable, long total) {
        return new PageImpl(data, pageable, total);
    }

    private boolean isNullParam(QueryWrapper<ENTITY> queryWrapper, Criteria criteria) {
        return Objects.isNull(queryWrapper) || Objects.isNull(criteria);
    }

    private void buildQueryWrapperOrderBy(QueryWrapper<ENTITY> queryWrapper, Pageable pageable) {
        if (Objects.nonNull(pageable) && Objects.nonNull(pageable.getSort())) {
            pageable.getSort().get().forEach(order -> {
                String column = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, order.getProperty());
                if (Sort.Direction.ASC.equals((Object)order.getDirection())) {
                    queryWrapper.orderByAsc((Object)column);
                } else if (Sort.Direction.DESC.equals((Object)order.getDirection())) {
                    queryWrapper.orderByDesc((Object)column);
                }
            });
        }
    }
}

