/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.criteria.wrapper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.google.common.base.CaseFormat;
import com.qqt.platform.common.criteria.Criteria;
import com.qqt.platform.common.criteria.filter.Filter;
import com.qqt.platform.common.criteria.wrapper.QueryWrapperParam;
import com.qqt.platform.common.utils.ThreadLocalUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class QueryCriteriaParser {
    private static final String SERIAL_VERSION_UID = "serialVersionUID";
    private final Logger log = LoggerFactory.getLogger(QueryCriteriaParser.class);

    public List<QueryWrapperParam> parserCriteria(Criteria criteria) {
        ArrayList<QueryWrapperParam> wrapperParams = new ArrayList<QueryWrapperParam>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            Class<?> criteriaClass = criteria.getClass();
            Object object = ThreadLocalUtil.get("dataPermission");
            HashSet permissionSet = new HashSet();
            if (null != object) {
                Map map = (Map)object;
                permissionSet.addAll(map.keySet());
            }
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = BeanUtils.getPropertyDescriptors(criteriaClass)) {
                JSONObject jsonObject;
                Object obj;
                Method method;
                String fieldName = propertyDescriptor.getName();
                if (fieldName.equalsIgnoreCase(SERIAL_VERSION_UID) || fieldName.equals("class") || (method = propertyDescriptor.getReadMethod()) == null || !Objects.nonNull(obj = method.invoke((Object)criteria, new Object[0])) || !(obj instanceof Filter) || (jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)obj))).isEmpty()) continue;
                Set keySet = jsonObject.keySet();
                String key = (String)keySet.iterator().next();
                ArrayList value = jsonObject.get((Object)key);
                if (value instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)value;
                    value = new ArrayList(jsonArray);
                }
                QueryWrapperParam wrapperParam = new QueryWrapperParam();
                wrapperParam.setColumn(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, fieldName));
                wrapperParam.setCondition(key);
                wrapperParam.setValue(value);
                if (permissionSet.contains(fieldName)) {
                    wrapperParam.setType(SqlKeyword.OR);
                } else {
                    SqlKeyword type = criteria.getQueryMatchType();
                    wrapperParam.setType(type);
                }
                wrapperParams.add(wrapperParam);
            }
        }
        catch (Exception e) {
            this.log.error("Parser Criteria Has Exception", (Throwable)e);
        }
        return wrapperParams;
    }
}

