/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.domain;

import com.qqt.platform.common.dto.OperateLogDTO;
import com.qqt.platform.common.event.OperateLogPublisher;
import com.qqt.platform.common.security.SecurityUtils;
import com.qqt.platform.common.utils.ThreadLocalUtil;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.time.Instant;
import java.util.Optional;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class DataBaseAuditListener
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(DataBaseAuditListener.class);

    public static void main(String[] args) {
    }

    private void prePersist(Object object) throws IllegalArgumentException, IllegalAccessException {
        Class<?> aClass = object.getClass().getSuperclass();
        try {
            Object userId;
            Field createdBy = aClass.getDeclaredField("createdBy");
            createdBy.setAccessible(true);
            Object createdByValue = createdBy.get(object);
            if (createdByValue == null && (userId = ThreadLocalUtil.get("userId")) != null) {
                createdBy.set(object, userId);
            }
            Field createdDate = aClass.getDeclaredField("createdDate");
            createdDate.setAccessible(true);
            Object createdDateValue = createdDate.get(object);
            if (createdDateValue == null) {
                createdDate.set(object, Instant.now());
            }
        }
        catch (NoSuchFieldException e) {
            logger.error("\u53cd\u5c04\u83b7\u53d6\u5c5e\u6027\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private void PreUpdate(Object object) throws IllegalArgumentException, IllegalAccessException {
        Class<?> aClass = object.getClass().getSuperclass();
        try {
            Object userId;
            Field lastModifiedBy = aClass.getDeclaredField("lastModifiedBy");
            lastModifiedBy.setAccessible(true);
            Object lastModifiedByValue = lastModifiedBy.get(object);
            if (lastModifiedByValue == null && (userId = ThreadLocalUtil.get("userId")) != null) {
                lastModifiedBy.set(object, userId);
            }
            Field lastModifiedDate = aClass.getDeclaredField("lastModifiedDate");
            lastModifiedDate.setAccessible(true);
            Object lastModifiedDateValue = lastModifiedDate.get(object);
            if (lastModifiedDateValue == null) {
                lastModifiedDate.set(object, Instant.now());
            }
        }
        catch (NoSuchFieldException e) {
            logger.error("\u53cd\u5c04\u83b7\u53d6\u5c5e\u6027\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private Object getId(Object object) throws IllegalArgumentException, IllegalAccessException {
        Class<?> aClass = object.getClass().getSuperclass();
        try {
            Field id = aClass.getDeclaredField("id");
            return id.get(object);
        }
        catch (NoSuchFieldException e) {
            logger.error("\u53cd\u5c04\u83b7\u53d6\u5c5e\u6027\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        BoundSql boundSql = statementHandler.getBoundSql();
        Object obj = boundSql.getParameterObject();
        String sql = boundSql.getSql();
        logger.debug("\u8fdb\u5165\u62e6\u622a\u5668:{},{}", (Object)sql, obj);
        if (sql.trim().toUpperCase().startsWith("INSERT")) {
            this.prePersist(obj);
        } else if (sql.trim().toUpperCase().startsWith("UPDATE")) {
            this.prePersist(obj);
        } else if (sql.trim().toUpperCase().startsWith("DELETE")) {
            String login = null;
            Optional<String> optional = SecurityUtils.getCurrentUserLogin();
            if (optional.isPresent()) {
                login = optional.get();
            }
            logger.info("getCurrentUserLogin:{}", (Object)login);
            Object id = this.getId(obj);
            this.sendLogMessage("onDelete", id.toString(), login, obj.toString());
        }
        return invocation.proceed();
    }

    public Object plugin(Object o) {
        return Plugin.wrap((Object)o, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private void sendLogMessage(String operateType, String params, String login, String content) {
        try {
            OperateLogDTO operationLog = new OperateLogDTO();
            operationLog.setLogin(login);
            operationLog.setParams(params);
            operationLog.setOperateType(operateType);
            operationLog.setContent(content);
            OperateLogPublisher.publishEvent(operationLog);
        }
        catch (Exception e) {
            logger.error("Save operationLogService error:{}", (Throwable)e);
        }
    }
}

