/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.event;

import com.alibaba.fastjson.JSON;
import com.qqt.platform.common.component.KafkaProduceUtil;
import com.qqt.platform.common.config.KafkaMessage;
import com.qqt.platform.common.config.ServerConfiguration;
import com.qqt.platform.common.dto.LogErrorDTO;
import com.qqt.platform.common.event.ErrorLogEvent;
import com.qqt.platform.common.utils.LogAbstractUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ErrorLogListener {
    private static final Logger log = LoggerFactory.getLogger(ErrorLogListener.class);
    @Autowired
    private KafkaProduceUtil kafkaProduceUtil;
    @Autowired
    private ServerConfiguration serverConfiguration;
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Value(value="${spring.profiles.active}")
    private String env;

    @Async
    @Order
    @EventListener(value={ErrorLogEvent.class})
    public void saveErrorLog(ErrorLogEvent event) {
        Map source = (Map)event.getSource();
        LogErrorDTO logError = (LogErrorDTO)source.get("info");
        logError.setEnv(this.env);
        LogAbstractUtil.addOtherInfoToLog(logError, this.applicationName, this.serverConfiguration);
        KafkaMessage kafkaMessage = new KafkaMessage();
        kafkaMessage.setChannel("platform_error_log_" + this.env);
        kafkaMessage.setMessage(JSON.parseObject((String)JSON.toJSONString((Object)logError)));
        this.kafkaProduceUtil.sendMessage(kafkaMessage);
    }
}

