/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.facade.impl;

import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.dto.message.MessageBodyDTO;
import com.qqt.platform.common.dto.message.UserTargetDTO;
import com.qqt.platform.common.facade.BaseFacade;
import com.qqt.platform.common.facade.MessageReceiverProvide;
import com.qqt.platform.common.facade.MessageSendFacade;
import com.qqt.platform.common.feign.AdminMessageFeignService;
import com.qqt.platform.common.utils.ResultUtil;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class MessageSendFacadeImpl
extends BaseFacade
implements MessageSendFacade {
    private static final Logger log = LoggerFactory.getLogger(MessageSendFacadeImpl.class);
    @Autowired
    private AdminMessageFeignService adminMessageFeignService;

    @Override
    public ResultDTO sendMsg(MessageBodyDTO messageBody) {
        ResponseEntity<ResultDTO> responseEntity;
        log.debug("\u53d1\u9001\u6d88\u606f\u53c2\u6570\uff1a{}", (Object)messageBody);
        if (CollectionUtils.isEmpty(messageBody.getUserTargets()) || this.userTargetAllIsNull(messageBody.getUserTargets())) {
            ResultDTO<Set<UserTargetDTO>> resultDTO = this.getReceivers(messageBody);
            if (!resultDTO.getSuccess().booleanValue()) {
                return resultDTO;
            }
            messageBody.setUserTargets(resultDTO.getData());
        }
        if ((responseEntity = this.adminMessageFeignService.sendMsg(messageBody)) == null || responseEntity.getBody() == null) {
            log.warn("sendMsg result is null,params:{}", (Object)messageBody);
            return ResultUtil.fail("sendMsg result is null");
        }
        return (ResultDTO)responseEntity.getBody();
    }

    private boolean userTargetAllIsNull(Set<UserTargetDTO> set) {
        for (UserTargetDTO targetDTO : set) {
            if (targetDTO.getTargetId() == null) continue;
            return false;
        }
        return true;
    }

    private ResultDTO<Set<UserTargetDTO>> getReceivers(MessageBodyDTO messageBody) {
        if (messageBody == null) {
            log.warn("getReceiverList sendMsg params is null");
            return ResultUtil.fail("sendMsg params is null");
        }
        if (StringUtils.isBlank((CharSequence)messageBody.getReceiverConfigCode()) && messageBody.getCustomizeReceiverProvideBean() == null && messageBody.getUserTargetCompanyId() == null) {
            log.warn("getReceiverList sendMsg configCode and provideBean and UserTargetCompanyId is null");
            return ResultUtil.fail("configCode and provideBean and UserTargetCompanyId is null");
        }
        if (messageBody.getCustomizeReceiverProvideBean() != null) {
            MessageReceiverProvide provideBean = messageBody.getCustomizeReceiverProvideBean();
            ResultDTO<Set<UserTargetDTO>> result = provideBean.getReceiverList(messageBody.getBillRelations());
            if (result.getSuccess().booleanValue() && CollectionUtils.isNotEmpty((Collection)result.getData())) {
                return result;
            }
            if (StringUtils.isNotBlank((CharSequence)messageBody.getReceiverConfigCode()) || messageBody.getUserTargetCompanyId() != null) {
                return this.readUserTargetsByConfig(messageBody);
            }
            log.warn("getReceiverList error:{},params:{}", (Object)result.getMsg(), (Object)messageBody);
            return result;
        }
        return this.readUserTargetsByConfig(messageBody);
    }

    private ResultDTO<Set<UserTargetDTO>> readUserTargetsByConfig(MessageBodyDTO messageBody) {
        ResponseEntity<ResultDTO<Set<UserTargetDTO>>> targets = this.adminMessageFeignService.getUserTargetsByConfig(messageBody);
        if (targets == null || targets.getBody() == null) {
            log.warn("readUserTargetsByConfig receiverConfig query result is null");
            return ResultUtil.fail("receiverConfig query result is null");
        }
        ResultDTO body = (ResultDTO)targets.getBody();
        if (!body.getSuccess().booleanValue()) {
            log.warn("readUserTargetsByConfig error:{},params:{}", (Object)body.getMsg(), (Object)messageBody);
        } else if (CollectionUtils.isEmpty((Collection)((Collection)body.getData()))) {
            log.warn("readUserTargetsByConfig error:{},params:{},receiverConfig query data is null", (Object)body.getMsg(), (Object)messageBody);
            return ResultUtil.fail("receiverConfig query data is null");
        }
        return body;
    }
}

