/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.facade.provide;

import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.dto.UserDTO;
import com.qqt.platform.common.dto.message.BillRelationDTO;
import com.qqt.platform.common.dto.message.UserTargetDTO;
import com.qqt.platform.common.facade.MessageReceiverProvide;
import com.qqt.platform.common.feign.AdminFeignService;
import com.qqt.platform.common.utils.ResultUtil;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;

public abstract class AbstractMessageReceiverProvideImpl
implements MessageReceiverProvide {
    private final Logger log = LoggerFactory.getLogger(AbstractMessageReceiverProvideImpl.class);
    @Autowired
    private AdminFeignService adminFeignService;

    @Override
    public ResultDTO<Set<UserTargetDTO>> getReceiverList(List<BillRelationDTO> billRelationDTOS) {
        this.log.debug("getReceiverList params:{}", billRelationDTOS);
        if (CollectionUtils.isEmpty(billRelationDTOS)) {
            return ResultUtil.fail("getReceiverList params can not empty");
        }
        ResultDTO valid = this.validBillRelationDTO(billRelationDTOS);
        if (!valid.getSuccess().booleanValue()) {
            return valid;
        }
        return this.process(billRelationDTOS);
    }

    public abstract ResultDTO<Set<UserTargetDTO>> process(List<BillRelationDTO> var1);

    private ResultDTO validBillRelationDTO(List<BillRelationDTO> billRelationDTOS) {
        for (BillRelationDTO relation : billRelationDTOS) {
            if (relation.getBillId() == null) {
                return ResultUtil.fail("getReceiverList params BillId is empty");
            }
            if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{relation.getReceIdField(), relation.getReceType(), relation.getTableName()})) continue;
            return ResultUtil.fail("getReceiverList params some is empty");
        }
        return ResultUtil.success();
    }

    public String getCurrentUserName(Long userId) {
        block6: {
            if (userId != null) {
                UserDTO userDTO = null;
                try {
                    ResponseEntity<ResultDTO<UserDTO>> userEntity = this.adminFeignService.getUserById(userId);
                    if (userEntity != null && userEntity.getBody() != null && ((ResultDTO)userEntity.getBody()).getData() != null) {
                        ResultDTO resultDTO = (ResultDTO)userEntity.getBody();
                        if (resultDTO.getData() != null) {
                            userDTO = (UserDTO)resultDTO.getData();
                            if (StringUtils.isBlank((CharSequence)userDTO.getNameCn())) {
                                return userId + "";
                            }
                            return userDTO.getNameCn();
                        }
                        break block6;
                    }
                    return userId + "";
                }
                catch (Exception e) {
                    this.log.error("getUserDetail userId error,userId:{},error:{}", (Object)userId, (Object)e);
                    return userId + "";
                }
            }
        }
        return null;
    }
}

