/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.request;

import com.qqt.platform.common.config.XssProperties;
import com.qqt.platform.common.request.XssHttpServletRequestWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestFilter
implements Filter {
    private final Logger log = LoggerFactory.getLogger(RequestFilter.class);
    private final XssProperties xssProperties;

    public void init(FilterConfig config) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String path = ((HttpServletRequest)request).getServletPath();
        this.log.debug("\u662f\u5426\u8d70xss\u8fc7\u6ee4:{}", (Object)(this.xssProperties.getEnabled() != false && !this.isSkip(path) ? 1 : 0));
        this.log.debug("\u5ffd\u7565\u7684api:{}", this.xssProperties.getSkipUrl());
        if (this.xssProperties.getEnabled().booleanValue() && !this.isSkip(path)) {
            XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper((HttpServletRequest)request);
            chain.doFilter((ServletRequest)xssRequest, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean isSkip(String path) {
        return this.xssProperties.getSkipUrl().stream().map(url -> url.replace("/**", "")).anyMatch(path::startsWith);
    }

    public void destroy() {
    }

    public RequestFilter(XssProperties xssProperties) {
        this.xssProperties = xssProperties;
    }
}

