/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.service;

import com.qqt.platform.common.component.ExceptionHandlingAsyncTaskExecutor;
import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.dto.SerialNumGeneratorDO;
import com.qqt.platform.common.feign.AdminFeignService;
import com.qqt.platform.common.service.FormNoSerialUtil;
import com.qqt.platform.common.service.FormNoTypeEnum;
import com.qqt.platform.common.utils.SnowflakeIdWorker;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service
public class SerialNumberGeneratorService {
    private final Logger logger = LoggerFactory.getLogger(SerialNumberGeneratorService.class);
    private static final String PREFIX_DEFAULT = "default";
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired(required=false)
    private ExceptionHandlingAsyncTaskExecutor asyncTaskExecutor;
    @Autowired
    private AdminFeignService adminFeignService;

    public String generateSerialNumber(String prefixString) {
        try {
            return prefixString + this.snowflakeIdWorker.nextId();
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
            return "";
        }
    }

    public String generateSerialNumber(FormNoTypeEnum formNoTypeEnum) {
        return this.generateSerialNumber(formNoTypeEnum.getPrefix(), formNoTypeEnum.getDatePattern(), formNoTypeEnum.getSerialLength());
    }

    public String generateSerialNumber(String prefix, String datePattern, Integer serialLength) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(datePattern);
            String format = formatter.format(LocalDateTime.now());
            StringBuffer sb = new StringBuffer();
            sb.append(prefix);
            sb.append(format);
            String formNoPrefix = sb.toString();
            Long incrementalSerial = 1L;
            try {
                byte[] val = this.redisTemplate.getConnectionFactory().getConnection().get(this.redisTemplate.getKeySerializer().serialize((Object)prefix));
                boolean flag = false;
                if (val == null) {
                    ResultDTO<SerialNumGeneratorDO> resultDTO = null;
                    try {
                        if ("".equals(prefix)) {
                            prefix = PREFIX_DEFAULT;
                        }
                        resultDTO = this.adminFeignService.getUniqueSerialNumberGenerator(prefix, format, serialLength);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.logger.info("\u751f\u6210\u5e8f\u5217\u53f7\u53c2\u6570-\u524d\u7f00:{}-\u65f6\u95f4\u683c\u5f0f:{}-\u957f\u5ea6:{},\u4ecedb\u4e2d\u83b7\u53d6\u7684\u5e8f\u5217\u53f7\u6570\u636e:{}", new Object[]{prefix, format, serialLength, resultDTO != null ? resultDTO.getData() : null});
                    if (resultDTO != null && resultDTO.getSuccess().booleanValue() && resultDTO.getData() != null && resultDTO.getData().getCurAutoNum() != null) {
                        long timeout = this.getTimeout();
                        SerialNumGeneratorDO data = resultDTO.getData();
                        Long curAutoNum = data.getCurAutoNum();
                        incrementalSerial = curAutoNum + 1L;
                        this.logger.info("\u751f\u6210\u5e8f\u5217\u53f7\u53c2\u6570-\u524d\u7f00:{}-\u65f6\u95f4\u683c\u5f0f:{}-\u957f\u5ea6:{},\u65b0\u7684\u5e8f\u5217\u53f7:{}", new Object[]{prefix, format, serialLength, incrementalSerial});
                        this.redisTemplate.getConnectionFactory().getConnection().setEx(this.redisTemplate.getKeySerializer().serialize((Object)prefix), TimeUnit.MILLISECONDS.toSeconds(timeout), this.redisTemplate.getKeySerializer().serialize((Object)incrementalSerial.toString()));
                        this.syncDB(prefix, format, serialLength, incrementalSerial, data.getId());
                    } else {
                        flag = true;
                    }
                }
                if ((val != null || flag) && (incrementalSerial = this.redisTemplate.getConnectionFactory().getConnection().incr(this.redisTemplate.getKeySerializer().serialize((Object)prefix))) != null) {
                    if (incrementalSerial == 1L) {
                        long timeout = this.getTimeout();
                        this.redisTemplate.expire((Object)prefix, timeout, TimeUnit.MILLISECONDS);
                    }
                    this.syncDB(prefix, format, serialLength, incrementalSerial, null);
                }
            }
            catch (Exception e) {
                this.logger.error("generateSequenceNumber error\uff1a", (Throwable)e);
            }
            String serialWithPrefix = FormNoSerialUtil.completionSerial(formNoPrefix, incrementalSerial, serialLength);
            return serialWithPrefix;
        }
        catch (Exception ex) {
            this.logger.error("generateSequenceNumber error\uff1a", (Throwable)ex);
            return "";
        }
    }

    private long getTimeout() {
        LocalDateTime now = LocalDateTime.now();
        LocalDate tomorrow = now.toLocalDate().plusDays(1L);
        LocalDateTime last = tomorrow.atTime(0, 0, 0, 0);
        long end = last.toInstant(ZoneOffset.UTC).toEpochMilli();
        long start = now.toInstant(ZoneOffset.UTC).toEpochMilli();
        long timeout = end - start;
        return timeout;
    }

    private void syncDB(String prefix, String datePattern, Integer serialLength, Long serialNo, Long id) {
        SerialNumGeneratorDO data = new SerialNumGeneratorDO();
        data.setId(id);
        data.setDatePattern(datePattern);
        if (StringUtils.isEmpty((CharSequence)prefix)) {
            data.setPrefix(PREFIX_DEFAULT);
        } else {
            data.setPrefix(prefix);
        }
        data.setSerialLength(serialLength);
        data.setCurAutoNum(serialNo);
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        SecurityContext context = SecurityContextHolder.getContext();
        this.asyncTaskExecutor.execute(() -> {
            SecurityContextHolder.setContext((SecurityContext)context);
            RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
            ResultDTO dto = this.adminFeignService.syncSerialNumberGenerator(data);
            this.logger.info("\u751f\u6210\u5e8f\u5217\u53f7\u53c2\u6570-\u524d\u7f00:{}-\u65f6\u95f4\u683c\u5f0f:{}-\u957f\u5ea6:{},\u5f02\u6b65\u540c\u6b65db\u7684\u5e8f\u5217\u53f7\uff0c\u662f\u5426\u6210\u529f:{}", new Object[]{prefix, datePattern, serialLength, dto.getSuccess()});
        });
    }
}

