/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.transactionthread;

import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public abstract class TransactionAsyCallThead<T>
implements Callable<T> {
    private final Logger log = LoggerFactory.getLogger(TransactionAsyCallThead.class);
    private PlatformTransactionManager transactionManager;

    public TransactionAsyCallThead(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public T call() throws Exception {
        this.log.info("\u5e26\u8fd4\u56de\u503c\u7ebf\u7a0b:{},\u5f00\u59cb\u5904\u7406", (Object)Thread.currentThread().getName());
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        definition.setPropagationBehavior(3);
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)definition);
        try {
            T result = this.doTransaction();
            this.transactionManager.commit(status);
            return result;
        }
        catch (Exception e) {
            this.log.error("\u5e26\u8fd4\u56de\u503c\u4e8b\u52a1\u7ebf\u7a0b\u53d1\u751f\u5f02\u5e38:{}", (Throwable)e);
            this.transactionManager.rollback(status);
            throw e;
        }
    }

    public abstract T doTransaction() throws Exception;
}

