/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.utils;

import com.qqt.platform.common.config.ServerConfiguration;
import com.qqt.platform.common.dto.LogAbstract;
import com.qqt.platform.common.utils.UrlUtil;
import com.qqt.platform.common.utils.WebUtil;
import java.util.Date;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;

public class LogAbstractUtil {
    public static void addRequestInfoToLog(HttpServletRequest request, LogAbstract logAbstract) {
        if (Objects.nonNull(request)) {
            logAbstract.setRemoteIp(WebUtil.getIP(request));
            logAbstract.setUserAgent(request.getHeader("user-agent"));
            logAbstract.setRequestUri(UrlUtil.getPath(request.getRequestURI()));
            logAbstract.setMethod(request.getMethod());
            if (null == logAbstract.getParams()) {
                logAbstract.setParams(WebUtil.getRequestContent(request));
            }
            logAbstract.setCreateTime(new Date());
        }
    }

    public static void addOtherInfoToLog(LogAbstract logAbstract, String applicationName, ServerConfiguration serverConfiguration) {
        logAbstract.setServiceId(applicationName);
        logAbstract.setServerHost(serverConfiguration.getHostName());
        logAbstract.setServerIp(serverConfiguration.getIpWithPort());
        logAbstract.setCreateTime(new Date());
        if (null == logAbstract.getParams()) {
            logAbstract.setParams("");
        }
    }
}

