/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.utils;

public class SnowflakeIdWorker {
    private static final Long WORKER_ID_BITS = 5L;
    private static final Long DATACENTER_ID_BITS = 5L;
    private static final Long MAX_WORKER_ID = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)WORKER_ID_BITS.longValue();
    private static final Long MAX_DATACENTER_ID = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)DATACENTER_ID_BITS.longValue();
    private static final Long SEQUENCE_BITS;
    private static final Long WORKER_ID_SHIFT;
    private static final Long DATACENTER_ID_SHIFT;
    private static final Long TIMESTAMP_LEFT_SHIFT;
    private static final Long SEQUENCE_MASK;
    private final Long twepoch = 1420041600000L;
    private final Long workerId;
    private final Long datacenterId;
    private Long sequence = 0L;
    private Long lastTimestamp = -1L;

    public SnowflakeIdWorker(long workerId, long datacenterId) {
        if (workerId > MAX_WORKER_ID || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", MAX_WORKER_ID));
        }
        if (datacenterId > MAX_DATACENTER_ID || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", MAX_DATACENTER_ID));
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
    }

    public static void main(String[] args) {
        SnowflakeIdWorker idWorker = new SnowflakeIdWorker(0L, 0L);
        for (int i = 0; i < 100; ++i) {
            long id = idWorker.nextId();
            System.out.println(Long.toBinaryString(id));
            System.out.println(id);
        }
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & SEQUENCE_MASK;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.twepoch << (int)TIMESTAMP_LEFT_SHIFT.longValue() | this.datacenterId << (int)DATACENTER_ID_SHIFT.longValue() | this.workerId << (int)WORKER_ID_SHIFT.longValue() | this.sequence;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }

    static {
        WORKER_ID_SHIFT = SEQUENCE_BITS = Long.valueOf(12L);
        DATACENTER_ID_SHIFT = SEQUENCE_BITS + WORKER_ID_BITS;
        TIMESTAMP_LEFT_SHIFT = SEQUENCE_BITS + WORKER_ID_BITS + DATACENTER_ID_BITS;
        SEQUENCE_MASK = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)SEQUENCE_BITS.longValue();
    }
}

