/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.base;

import com.alibaba.fastjson.JSON;
import com.qqt.pool.base.PoolClient;
import com.qqt.pool.base.exception.BusinessException;
import com.qqt.pool.base.request.PoolRequestBean;
import com.qqt.pool.base.response.PoolRespBean;
import com.qqt.pool.base.utils.HttpClientUtil;
import com.qqt.pool.base.utils.JdkSignatureUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPoolClient
implements PoolClient {
    private static Logger logger = LoggerFactory.getLogger(DefaultPoolClient.class);

    @Override
    public <T extends PoolRespBean> T execute(String poolUrl, PoolRequestBean request, String key) throws BusinessException {
        String req = JSON.toJSONString((Object)request);
        logger.debug("\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)req);
        String resp = null;
        HashMap<String, String> headParams = new HashMap<String, String>();
        try {
            headParams.put("sign", JdkSignatureUtil.executeSignature(key, req));
        }
        catch (Exception e) {
            logger.error("\u7b7e\u540d\u5931\u8d25", (Object)e.getMessage());
            throw new BusinessException("signature failure", "\u7b7e\u540d\u5931\u8d25");
        }
        try {
            resp = HttpClientUtil.doPostJson(poolUrl, headParams, req, null);
        }
        catch (Exception e) {
            logger.error("\u63a5\u53e3\u8c03\u7528\u5931\u8d25", (Throwable)e);
            throw new BusinessException("Interface call failure", "\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        logger.debug("\u56de\u590d\u62a5\u6587\uff1a{}", (Object)resp);
        PoolRespBean t = (PoolRespBean)JSON.parseObject((String)resp, request.getResponseClass());
        this.checkRequst(t);
        return (T)t;
    }

    private <T extends PoolRespBean> void checkRequst(T t) throws BusinessException {
        if (t == null) {
            logger.error("\u62a5\u6587\u89e3\u6790\u5931\u8d25");
            throw new BusinessException("packet parsing failure", "\u62a5\u6587\u89e3\u6790\u5931\u8d25");
        }
        if (t.getReturncode() == null || "".equals(t.getReturncode()) || Integer.parseInt(t.getReturncode()) != 0) {
            throw new BusinessException(t.getReturnmsg(), t.getReturnmsg());
        }
        t.setReturncode(Integer.parseInt(t.getReturncode()) + "");
    }
}

