/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.aop;

import com.qqt.pool.common.event.UsualLogPublisher;
import com.qqt.pool.tool.jackson.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;

public class UsualLogger
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(UsualLogger.class);
    @Value(value="${spring.application.name}")
    private String serviceId;
    @Value(value="${saveLog.usual.infoEnabled:false}")
    private boolean isInfoEnabled;
    @Value(value="${saveLog.usual.errorEnabled:false}")
    private boolean isErrorEnabled;
    @Value(value="${saveLog.usual.warnEnabled:false}")
    private boolean isWarnEnabled;
    @Value(value="${saveLog.usual.debugEnabled:false}")
    private boolean isDebugEnabled;

    public void info(String id, Object data) {
        if (this.isInfoEnabled) {
            UsualLogPublisher.publishEvent("info", id, JsonUtil.toJson((Object)data));
        }
    }

    public void debug(String id, Object data) {
        if (this.isDebugEnabled) {
            UsualLogPublisher.publishEvent("debug", id, JsonUtil.toJson((Object)data));
        }
    }

    public void warn(String id, Object data) {
        if (this.isWarnEnabled) {
            UsualLogPublisher.publishEvent("warn", id, JsonUtil.toJson((Object)data));
        }
    }

    public void error(String id, Object data) {
        if (this.isErrorEnabled) {
            UsualLogPublisher.publishEvent("error", id, JsonUtil.toJson((Object)data));
        }
    }

    public void afterPropertiesSet() throws Exception {
        log.info("{}: UsualLogger init success!", (Object)this.serviceId);
    }
}

