/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.event;

import com.alibaba.fastjson.JSON;
import com.qqt.pool.common.config.KafkaMessage;
import com.qqt.pool.common.config.ServerConfiguration;
import com.qqt.pool.common.dto.LogApiDTO;
import com.qqt.pool.common.event.ApiLogEvent;
import com.qqt.pool.common.utils.KafkaProduceUtil;
import com.qqt.pool.common.utils.LogAbstractUtil;
import io.github.jhipster.config.JHipsterProperties;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ApiLogListener {
    private static final Logger log = LoggerFactory.getLogger(ApiLogListener.class);
    private final KafkaProduceUtil kafkaProduceUtil;
    private final ServerConfiguration serverConfiguration;
    private final Environment environment;
    private final JHipsterProperties jHipsterProperties;

    @Async
    @Order
    @EventListener(value={ApiLogEvent.class})
    public void saveApiLog(ApiLogEvent event) {
        Map source = (Map)event.getSource();
        LogApiDTO logApi = (LogApiDTO)source.get("info");
        LogAbstractUtil.addOtherInfoToLog(logApi, this.jHipsterProperties, this.environment, this.serverConfiguration);
        KafkaMessage kafkaMessage = new KafkaMessage();
        kafkaMessage.setChannel("topic-api-log");
        kafkaMessage.setMessage(JSON.parseObject((String)JSON.toJSONString((Object)logApi)));
        this.kafkaProduceUtil.sendMessage(kafkaMessage);
    }

    public ApiLogListener(KafkaProduceUtil kafkaProduceUtil, ServerConfiguration serverConfiguration, Environment environment, JHipsterProperties jHipsterProperties) {
        this.kafkaProduceUtil = kafkaProduceUtil;
        this.serverConfiguration = serverConfiguration;
        this.environment = environment;
        this.jHipsterProperties = jHipsterProperties;
    }
}

