/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.event;

import com.alibaba.fastjson.JSON;
import com.qqt.pool.common.config.KafkaMessage;
import com.qqt.pool.common.config.ServerConfiguration;
import com.qqt.pool.common.dto.LogErrorDTO;
import com.qqt.pool.common.event.ErrorLogEvent;
import com.qqt.pool.common.utils.KafkaProduceUtil;
import com.qqt.pool.common.utils.LogAbstractUtil;
import io.github.jhipster.config.JHipsterProperties;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ErrorLogListener {
    private static final Logger log = LoggerFactory.getLogger(ErrorLogListener.class);
    private final ServerConfiguration serverConfiguration;
    private final Environment environment;
    private final JHipsterProperties jHipsterProperties;
    private final KafkaProduceUtil kafkaProduceUtil;

    @Async
    @Order
    @EventListener(value={ErrorLogEvent.class})
    public void saveErrorLog(ErrorLogEvent event) {
        Map source = (Map)event.getSource();
        LogErrorDTO logError = (LogErrorDTO)source.get("info");
        LogAbstractUtil.addOtherInfoToLog(logError, this.jHipsterProperties, this.environment, this.serverConfiguration);
        KafkaMessage kafkaMessage = new KafkaMessage();
        kafkaMessage.setChannel("topic-error-log");
        kafkaMessage.setMessage(JSON.parseObject((String)JSON.toJSONString((Object)logError)));
        this.kafkaProduceUtil.sendMessage(kafkaMessage);
    }

    public ErrorLogListener(ServerConfiguration serverConfiguration, Environment environment, JHipsterProperties jHipsterProperties, KafkaProduceUtil kafkaProduceUtil) {
        this.serverConfiguration = serverConfiguration;
        this.environment = environment;
        this.jHipsterProperties = jHipsterProperties;
        this.kafkaProduceUtil = kafkaProduceUtil;
    }
}

