/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.event;

import com.alibaba.fastjson.JSON;
import com.qqt.pool.common.config.KafkaMessage;
import com.qqt.pool.common.config.ServerConfiguration;
import com.qqt.pool.common.dto.LogUsualDTO;
import com.qqt.pool.common.event.UsualLogEvent;
import com.qqt.pool.common.utils.KafkaProduceUtil;
import com.qqt.pool.common.utils.LogAbstractUtil;
import io.github.jhipster.config.JHipsterProperties;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class UsualLogListener {
    private static final Logger log = LoggerFactory.getLogger(UsualLogListener.class);
    private final KafkaProduceUtil kafkaProduceUtil;
    private final ServerConfiguration serverConfiguration;
    private final Environment environment;
    private final JHipsterProperties jHipsterProperties;

    @Async
    @Order
    @EventListener(value={UsualLogEvent.class})
    public void saveUsualLog(UsualLogEvent event) {
        Map source = (Map)event.getSource();
        LogUsualDTO logUsual = (LogUsualDTO)source.get("info");
        LogAbstractUtil.addOtherInfoToLog(logUsual, this.jHipsterProperties, this.environment, this.serverConfiguration);
        KafkaMessage kafkaMessage = new KafkaMessage();
        kafkaMessage.setChannel("topic-usual-log");
        kafkaMessage.setMessage(JSON.parseObject((String)JSON.toJSONString((Object)logUsual)));
        this.kafkaProduceUtil.sendMessage(kafkaMessage);
    }

    public UsualLogListener(KafkaProduceUtil kafkaProduceUtil, ServerConfiguration serverConfiguration, Environment environment, JHipsterProperties jHipsterProperties) {
        this.kafkaProduceUtil = kafkaProduceUtil;
        this.serverConfiguration = serverConfiguration;
        this.environment = environment;
        this.jHipsterProperties = jHipsterProperties;
    }
}

