/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.service;

import com.qqt.pool.common.service.FormNoSerialUtil;
import com.qqt.pool.common.service.FormNoTypeEnum;
import com.qqt.pool.common.utils.SnowflakeIdWorker;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class SerialNumberGeneratorService {
    private Logger logger = LoggerFactory.getLogger(SerialNumberGeneratorService.class);
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    RedisTemplate redisTemplate;

    public String generateSerialNumber(String prefixString) {
        try {
            return prefixString + this.snowflakeIdWorker.nextId();
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
            return "";
        }
    }

    public String generateSerialNumber(FormNoTypeEnum formNoTypeEnum) {
        return this.generateSerialNumber(formNoTypeEnum.getPrefix(), formNoTypeEnum.getDatePattern(), formNoTypeEnum.getSerialLength());
    }

    public String generateSerialNumber(String prefix, String datePattern, Integer serialLength) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(datePattern);
            StringBuffer sb = new StringBuffer();
            sb.append(prefix);
            sb.append(formatter.format(LocalDateTime.now()));
            String formNoPrefix = sb.toString();
            String cacheKey = FormNoSerialUtil.getCacheKey(formNoPrefix);
            Long incrementalSerial = 1L;
            try {
                incrementalSerial = this.redisTemplate.getConnectionFactory().getConnection().incr(this.redisTemplate.getKeySerializer().serialize((Object)"i"));
                if (incrementalSerial != null && incrementalSerial == 1L) {
                    this.redisTemplate.expire((Object)cacheKey, 1L, TimeUnit.DAYS);
                }
            }
            catch (Exception e) {
                this.logger.error("generateSequenceNumber error\uff1a", (Throwable)e);
            }
            String serialWithPrefix = FormNoSerialUtil.completionSerial(formNoPrefix, incrementalSerial, serialLength);
            return serialWithPrefix;
        }
        catch (Exception ex) {
            this.logger.error("generateSequenceNumber error\uff1a", (Throwable)ex);
            return "";
        }
    }
}

