/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.google.common.collect.ImmutableList;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import io.vavr.control.Try;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheManager {
    private static final Logger log = LoggerFactory.getLogger(CacheManager.class);
    private static final List<Cache<CacheKey, ?>> cacheList = new ArrayList();

    @Nonnull
    public static ImmutableList<Cache<CacheKey, ?>> getCacheList() {
        return ImmutableList.copyOf(cacheList);
    }

    @Nonnull
    public static synchronized <T> Cache<CacheKey, T> register(@Nonnull Cache<CacheKey, T> cache) {
        cacheList.add(cache);
        return cache;
    }

    public static void cleanUp() {
        for (Cache<CacheKey, ?> cache : cacheList) {
            cache.cleanUp();
        }
        if (log.isInfoEnabled()) {
            log.info("Clean up of invalidated caches finished successfully.");
        }
    }

    public static long invalidateAll() {
        long size = 0L;
        for (Cache<CacheKey, ?> cache : cacheList) {
            size += cache.estimatedSize();
            cache.invalidateAll();
        }
        if (log.isInfoEnabled()) {
            log.info("Successfully invalidated roughly " + size + " " + (size == 1L ? "entry" : "entries") + " in " + cacheList.size() + " " + (cacheList.size() == 1 ? "cache" : "caches") + ".");
        }
        return size;
    }

    public static long invalidateTenantCaches() {
        Try tenantTry = TenantAccessor.tryGetCurrentTenant();
        if (tenantTry.isSuccess()) {
            return CacheManager.invalidateTenantCaches(((Tenant)tenantTry.get()).getTenantId());
        }
        return 0L;
    }

    public static long invalidateTenantCaches(@Nonnull String tenantId) {
        long size = 0L;
        for (Cache<CacheKey, ?> cache : cacheList) {
            ArrayList<CacheKey> keysToInvalidate = new ArrayList<CacheKey>();
            for (CacheKey cacheKey : cache.asMap().keySet()) {
                if (log.isDebugEnabled()) {
                    log.debug("Checking cache invalidation for tenant '" + tenantId + "': " + cacheKey + ".");
                }
                if (!tenantId.equals(cacheKey.getTenantId().getOrNull())) continue;
                keysToInvalidate.add(cacheKey);
            }
            if (log.isDebugEnabled()) {
                log.debug("Invalidating caches of tenant '" + tenantId + "': " + keysToInvalidate + ".");
            }
            size += (long)keysToInvalidate.size();
            cache.invalidateAll(keysToInvalidate);
        }
        log.info("Successfully invalidated caches of tenant '" + tenantId + "': " + size + ".");
        return size;
    }

    public static long invalidatePrincipalCaches() {
        Try tenantTry = TenantAccessor.tryGetCurrentTenant();
        Try principalTry = PrincipalAccessor.tryGetCurrentPrincipal();
        if (tenantTry.isSuccess() && principalTry.isSuccess()) {
            return CacheManager.invalidatePrincipalCaches(((Tenant)tenantTry.get()).getTenantId(), ((Principal)principalTry.get()).getPrincipalId());
        }
        return 0L;
    }

    public static long invalidatePrincipalCaches(@Nonnull String tenantId, @Nonnull String principalId) {
        long size = 0L;
        for (Cache<CacheKey, ?> cache : cacheList) {
            if (log.isDebugEnabled()) {
                log.debug("Invalidating principal cache entries.");
            }
            size += CacheManager.invalidatePrincipalEntries(tenantId, principalId, cache);
        }
        log.info("Successfully invalidated caches of principal '" + principalId + "' within tenant '" + tenantId + "': " + size);
        return size;
    }

    public static long invalidatePrincipalEntries(@Nonnull Cache<CacheKey, ?> cache) {
        Try tenantTry = TenantAccessor.tryGetCurrentTenant();
        Try principalTry = PrincipalAccessor.tryGetCurrentPrincipal();
        if (tenantTry.isSuccess() && principalTry.isSuccess()) {
            return CacheManager.invalidatePrincipalEntries(((Tenant)tenantTry.get()).getTenantId(), ((Principal)principalTry.get()).getPrincipalId(), cache);
        }
        return 0L;
    }

    public static long invalidatePrincipalEntries(@Nonnull String tenantId, @Nonnull String principalId, @Nonnull Cache<CacheKey, ?> cache) {
        ArrayList<CacheKey> keysToInvalidate = new ArrayList<CacheKey>();
        for (CacheKey cacheKey : cache.asMap().keySet()) {
            if (log.isDebugEnabled()) {
                log.debug("Checking invalidation  for principal '" + principalId + "' within tenant '" + tenantId + "': " + cacheKey);
            }
            boolean isEqualTenantId = tenantId.equals(cacheKey.getTenantId().getOrNull());
            boolean isEqualPrincipalId = principalId.equals(cacheKey.getPrincipalId().getOrNull());
            if (!isEqualTenantId || !isEqualPrincipalId) continue;
            keysToInvalidate.add(cacheKey);
        }
        if (log.isDebugEnabled()) {
            log.debug("Invalidating caches of principal '" + principalId + "' within tenant '" + tenantId + "': " + keysToInvalidate);
        }
        long size = keysToInvalidate.size();
        cache.invalidateAll(keysToInvalidate);
        return size;
    }
}

