/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.exception;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.cloudplatform.servlet.response.PayloadTooLargeResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;
import com.sap.cloud.sdk.cloudplatform.servlet.response.WithErrorResponse;

public class PayloadTooLargeException extends RuntimeException implements WithErrorResponse
{
    private static final long serialVersionUID = -5891897716381404148L;

    /**
     * Exception constructor.
     * 
     * @param entity
     *            Entity type which is used in the payload.
     * @param maxNumber
     *            Maximum number entity data allowed in the payload.
     * @param actualNumber
     *            Actual number of entity data.
     */
    public PayloadTooLargeException( @Nonnull final Class<?> entity, final int maxNumber, final int actualNumber )
    {
        super(
            String.format(
                "Request too large. Maximum number of supplied '%s': %s. Actually provided: %s.",
                entity.getSimpleName(),
                maxNumber,
                actualNumber));
    }

    /**
     * {@inheritDoc}
     */
    @Nonnull
    @Override
    public ResponseWithErrorCode getErrorResponse()
    {
        return new PayloadTooLargeResponse(getMessage() + " Please provide less input for this operation to succeed.");
    }
}
