/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import javax.annotation.Nullable;

import org.apache.http.HttpStatus;

/**
 * Constraint Violation.
 */
public class ConstraintViolatedResponse extends ResponseWithErrorCode
{
    /**
     * Default constructor.
     */
    public ConstraintViolatedResponse()
    {
        this(null);
    }

    /**
     * Constructor with description.
     * 
     * @param description
     *            The optional error description.
     */
    public ConstraintViolatedResponse( @Nullable final String description )
    {
        super(HttpStatus.SC_BAD_REQUEST, "constraint_violated", description);
    }
}
