/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.HttpStatus;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.Expose;

import io.vavr.control.Option;

/**
 * Invalid Field Format.
 */
public class InvalidFieldFormatResponse extends ResponseWithErrorCode
{
    @Nullable
    @Expose
    @JsonProperty
    private final String field;

    /**
     * Get the invalid field format.
     * 
     * @return The invalid field format.
     */
    @JsonIgnore
    @Nonnull
    public Option<String> getField()
    {
        return Option.of(field);
    }

    /**
     * Default constructor.
     */
    public InvalidFieldFormatResponse()
    {
        this(null, null);
    }

    /**
     * Constructor with field reference.
     * 
     * @param field
     *            The optional field name having invalid format.
     * @param description
     *            The optional error description.
     */
    public InvalidFieldFormatResponse( @Nullable final String field, @Nullable final String description )
    {
        super(HttpStatus.SC_BAD_REQUEST, "invalid_field_format", description);
        this.field = field;
    }
}
