/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import javax.annotation.Nullable;

import org.apache.http.HttpStatus;

/**
 * Unsupported Operation.
 */
public class UnsupportedOperationResponse extends ResponseWithErrorCode
{
    /**
     * Default constructor.
     */
    public UnsupportedOperationResponse()
    {
        this(null);
    }

    /**
     * Constructor with description.
     * 
     * @param description
     *            The optional error description.
     */
    public UnsupportedOperationResponse( @Nullable final String description )
    {
        super(HttpStatus.SC_INTERNAL_SERVER_ERROR, "operation_not_supported", description);
    }
}
