/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response.mapper;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.cloudplatform.exception.ConstraintViolationException;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ConstraintViolatedResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.LogLevel;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;

public class ConstraintViolationExceptionMapper extends AbstractResponseMapper<ConstraintViolationException>
{
    @Nonnull
    @Override
    public Class<ConstraintViolationException> getThrowableClass()
    {
        return ConstraintViolationException.class;
    }

    @Override
    @Nonnull
    public ResponseWithErrorCode toResponse( @Nonnull final Throwable throwable )
    {
        return new ConstraintViolatedResponse(getErrorMessage(throwable));
    }

    @Nonnull
    @Override
    public LogLevel getLogLevel( @Nonnull final Throwable throwable )
    {
        return LogLevel.WARNING;
    }
}
