/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity;

import com.sap.cloud.sdk.odatav2.connectivity.ODataType;
import com.sap.cloud.sdk.odatav2.connectivity.ODataTypeValueSerializer;
import com.sap.cloud.sdk.odatav2.connectivity.filter.FilterHelperUtil;
import com.sap.cloud.sdk.odatav2.connectivity.internal.UrlEncoder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.edm.EdmTypeKind;
import org.apache.olingo.odata2.api.uri.expression.MethodOperator;

public class FilterExpression {
    private static final String BRACKET_OPEN = "(";
    private static final String BRACKET_CLOSE = ")";
    private HashMap<String, EdmType> typeMap = new HashMap();
    private final String AND = "and";
    private final String OR = "or";
    private final Object left;
    private final String operator;
    private final ODataType right;
    private FilterExpression rightFilter = null;
    private boolean isNot = false;
    private boolean isLeftFilterFunction = false;

    public static FilterExpression not(FilterExpression filter) {
        filter.setNot();
        return filter;
    }

    public FilterExpression(String field, String operator, ODataType right) {
        this.left = field;
        this.operator = operator;
        this.right = right;
        this.rightFilter = null;
    }

    public FilterExpression(String field, String operator, ODataType right, boolean isLeftFilterFunction) {
        this.left = field;
        this.operator = operator;
        this.right = right;
        this.rightFilter = null;
        this.isLeftFilterFunction = isLeftFilterFunction;
    }

    private FilterExpression(FilterExpression left, String operator, FilterExpression right) {
        this.left = left;
        this.rightFilter = right;
        this.operator = operator;
        this.right = null;
    }

    public FilterExpression or(FilterExpression orExpression) {
        return new FilterExpression(this, "or", orExpression);
    }

    public FilterExpression and(FilterExpression andExpression) {
        return new FilterExpression(this, "and", andExpression);
    }

    private String toStringBasic(EdmEntityType entityType, boolean isFilterFunction) throws EdmException {
        String converted = null;
        String field = this.left.toString();
        ODataType value = this.right;
        if (value != null) {
            if (entityType != null) {
                this.saveType(field, entityType);
                if (this.typeMap.containsKey(field)) {
                    Object val = value.getValue();
                    if (val instanceof String) {
                        val = UrlEncoder.encode(val.toString());
                    }
                    converted = ODataTypeValueSerializer.of(this.typeMap.get(field)).toUri(val);
                }
            } else {
                String stringVal = value.getValue().toString();
                if (value.getValue() instanceof String) {
                    stringVal = "'" + stringVal + "'";
                }
                converted = isFilterFunction ? stringVal : UrlEncoder.encode(stringVal);
            }
        }
        String filterString = field + " " + this.operator + " " + converted;
        return this.prependNOTIfRequired(filterString);
    }

    private void saveType(String property, EdmEntityType entityType) throws EdmException {
        if (this.typeMap.containsKey(property)) {
            return;
        }
        EdmEntityType targetEntityType = entityType;
        String[] navigationPath = property.split("/");
        int pathLengthExcludingProperty = navigationPath.length - 1;
        String targetProperty = navigationPath[pathLengthExcludingProperty];
        for (int i = 0; i < pathLengthExcludingProperty; ++i) {
            String navigationProperty = navigationPath[i];
            targetEntityType = this.getTargetEntityTypeFromNavigationProperty(targetEntityType, navigationProperty);
        }
        if (targetEntityType.getProperty(targetProperty) != null && targetEntityType.getProperty(targetProperty).getType().getKind().equals((Object)EdmTypeKind.SIMPLE)) {
            this.typeMap.put(property, targetEntityType.getProperty(targetProperty).getType());
        }
    }

    private EdmEntityType getTargetEntityTypeFromNavigationProperty(EdmEntityType entityType, String navigationProperty) throws EdmException {
        EdmNavigationProperty navProp = (EdmNavigationProperty)entityType.getProperty(navigationProperty);
        String toRole = navProp.getToRole();
        return navProp.getRelationship().getEnd(toRole).getEntityType();
    }

    public String toString(EdmEntityType entityType) throws EdmException {
        if (this.isMethodOperator()) {
            return this.getFilterString();
        }
        if (!(this.left instanceof FilterExpression) && !this.isLeftFilterFunction) {
            return this.toStringBasic(entityType, this.isLeftFilterFunction);
        }
        if (!(this.left instanceof FilterExpression) && this.isLeftFilterFunction) {
            return this.toStringBasic(null, this.isLeftFilterFunction);
        }
        FilterExpression leftFilter = (FilterExpression)this.left;
        String rightExp = this.rightFilter != null ? this.rightFilter.toString(entityType) : this.right.toString();
        String filterString = BRACKET_OPEN + leftFilter.toString(entityType) + BRACKET_CLOSE + " " + this.operator + " " + BRACKET_OPEN + rightExp + BRACKET_CLOSE;
        return this.prependNOTIfRequired(filterString);
    }

    private String getFilterString() throws EdmException {
        MethodOperator method = MethodOperator.valueOf((String)this.operator.toUpperCase());
        switch (method) {
            case SUBSTRINGOF: {
                return FilterHelperUtil.buildSubstringOfFunc(this.operator.toString(), this.right, this.left.toString());
            }
            case STARTSWITH: 
            case ENDSWITH: {
                return FilterHelperUtil.buildBinaryFunc(this.operator.toString(), this.left.toString(), this.right);
            }
        }
        throw new EdmException(null, "FILTER_NOT_SUPPORTED");
    }

    private boolean isMethodOperator() {
        try {
            MethodOperator.valueOf((String)this.operator.toUpperCase());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public String toString() {
        try {
            return this.toString(null);
        }
        catch (EdmException e) {
            return e.getMessage();
        }
    }

    private void setNot() {
        this.isNot = true;
    }

    private String prependNOTIfRequired(String filterString) {
        if (this.isNot) {
            return "not (" + filterString + BRACKET_CLOSE;
        }
        return filterString;
    }

    @ConstructorProperties(value={"left", "operator", "right"})
    public FilterExpression(Object left, String operator, ODataType right) {
        this.left = left;
        this.operator = operator;
        this.right = right;
    }
}

