/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity;

import com.google.common.collect.ImmutableList;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.HttpClientInstantiationException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataExceptionType;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryListener;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryResult;
import com.sap.cloud.sdk.odatav2.connectivity.ODataRequestExecutor;
import com.sap.cloud.sdk.odatav2.connectivity.cache.metadata.GuavaMetadataCache;
import com.sap.cloud.sdk.odatav2.connectivity.cache.metadata.MetadataCache;
import com.sap.cloud.sdk.odatav2.connectivity.internal.ODataConnectivityUtil;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.client.api.ODataClient;
import org.apache.olingo.odata2.client.api.edm.ClientEdm;
import org.slf4j.Logger;

public class ODataQuery {
    private static final Logger logger = CloudLoggerFactory.getLogger(ODataQuery.class);
    private MetadataCache metadataCache = new GuavaMetadataCache();
    private static final List<ODataQueryListener> queryListeners = ImmutableList.copyOf(ServiceLoader.load(ODataQueryListener.class));
    private static final String SEPARATOR_QUERY = "&";
    private static final String METADATA = "$metadata";
    @NonNull
    private final String servicePath;
    @NonNull
    private String entity;
    @Nullable
    private final Map<String, Object> keys;
    @NonNull
    private final ODataQueryBuilder.ODataQueryResolver oDataQueryResolver;
    @Nullable
    private final ErrorResultHandler<?> errorHandler;
    @Nullable
    private final Map<String, String> headers;
    @Nullable
    private final Map<String, String> destinationRelevantHeaders;
    private final boolean useMetadata;
    private final Boolean cacheMetadata;
    private final URL metadataFliePath;
    private final CacheKey cacheKey;
    private boolean isCacheRefresh;
    private boolean isMediaRequest = false;
    private EdmEntitySet entitymetadata = null;
    private EdmEntityType entityType = null;
    private String requestQuery;
    private String requestLocalPath;
    private HttpResponse httpResponse = null;
    private static final String REQUESTFAILURE = "Failed to execute OData request.";

    public ODataQuery(String servicePath, String entity, Map<String, Object> keys, ODataQueryBuilder.ODataQueryResolver oDataQueryResolver, ErrorResultHandler<?> errorHandler, Map<String, String> headers, Map<String, String> destinationRelevantHeaders, boolean useMetadata, boolean cacheMetadata, URL metadataFilePath, CacheKey cacheKey, boolean isCacheRefresh) {
        this.servicePath = servicePath;
        this.entity = entity;
        this.keys = keys;
        this.oDataQueryResolver = oDataQueryResolver;
        this.errorHandler = errorHandler;
        this.headers = headers;
        this.destinationRelevantHeaders = destinationRelevantHeaders;
        this.useMetadata = useMetadata;
        this.cacheMetadata = cacheMetadata;
        this.metadataFliePath = metadataFilePath;
        this.cacheKey = cacheKey;
        this.isCacheRefresh = isCacheRefresh;
    }

    public ODataQueryResult execute(HttpClient providedClient) throws ODataException {
        return this.execute(providedClient, false);
    }

    public ODataQueryResult execute(HttpClient providedClient, boolean isMediaRequest) throws ODataException {
        ODataQueryResult result = null;
        try {
            result = this.internalExecute(null, isMediaRequest, true, providedClient);
        }
        catch (ODataException e) {
            if (e.getODataExceptionType().equals((Object)ODataExceptionType.OTHER) || e.getODataExceptionType().equals((Object)ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED)) {
                throw e;
            }
            result = this.retryExecuteWithCompleteUrl(null, providedClient, e);
        }
        return result;
    }

    private ODataQueryResult retryExecuteWithCompleteUrl(String destinationName, HttpClient providedClient, ODataException e) throws ODataException {
        try {
            this.getUri(this.getServiceUrl(destinationName), this.getMetadataQuery(destinationName), null).toString();
        }
        catch (URISyntaxException e1) {
            throw new ODataException(ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED, REQUESTFAILURE, e);
        }
        this.isCacheRefresh = true;
        ODataQueryResult result = this.internalExecute(destinationName, this.isMediaRequest, false, providedClient);
        return result;
    }

    ODataQueryResult execute(String destinationName, boolean isMediaRequest) throws ODataException {
        ODataQueryResult result = null;
        this.isMediaRequest = isMediaRequest;
        try {
            result = this.internalExecute(destinationName, isMediaRequest, false, null);
        }
        catch (ODataException e) {
            if (e.getODataExceptionType().equals((Object)ODataExceptionType.OTHER) || e.getODataExceptionType().equals((Object)ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED)) {
                throw e;
            }
            result = this.retryExecuteWithCompleteUrl(destinationName, null, e);
        }
        return result;
    }

    public ODataQueryResult execute(WithDestinationName withDestinationName) throws ODataException {
        ODataQueryResult result = null;
        try {
            result = this.execute(withDestinationName.getDestinationName());
        }
        catch (ODataException e) {
            if (e.getODataExceptionType().equals((Object)ODataExceptionType.OTHER) || e.getODataExceptionType().equals((Object)ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED)) {
                throw e;
            }
            this.isCacheRefresh = true;
            result = this.execute(withDestinationName.getDestinationName());
        }
        return result;
    }

    public ODataQueryResult execute(String destinationName) throws ODataException {
        if (destinationName == null) {
            throw new ODataException(null, "Missing destination name configuration, please declare an endpoint for the OData query.", null);
        }
        return this.execute(destinationName, false);
    }

    private ODataQueryResult internalExecute(String destinationName, boolean isMediaRequest, boolean withDefaultClient, HttpClient providedClient) throws ODataException {
        this.notifyQueryListeners(destinationName);
        try {
            if (StringUtils.isEmpty((CharSequence)this.servicePath)) {
                throw new ODataException(null, "Missing service in OData query.", null);
            }
            if (StringUtils.isEmpty((CharSequence)this.entity)) {
                throw new ODataException(null, "Missing entity in OData query.", null);
            }
            HttpClient httpClient = destinationName == null ? providedClient : HttpClientAccessor.getHttpClient((String)destinationName);
            URI serviceUrl = this.getServiceUrl(destinationName);
            this.httpResponse = this.loadEntriesFromDestination(destinationName, serviceUrl, isMediaRequest, httpClient);
            ODataQueryResult result = new ODataQueryResult(this.entitymetadata, this.httpResponse, isMediaRequest);
            result.setQuery(this);
            ODataQueryResult oDataQueryResult = result;
            return oDataQueryResult;
        }
        catch (DestinationAccessException | DestinationNotFoundException | HttpClientInstantiationException | IOException | IllegalStateException | URISyntaxException | EdmException e) {
            if (e instanceof DestinationAccessException) {
                logger.error("Could not connect to destination service [No Access] :" + e.getMessage());
                logger.error("Could not connect to destination service [No Access] : " + e.getStackTrace());
            } else if (e instanceof DestinationNotFoundException) {
                logger.error("Could not connect to destination service [Not Found] :" + e.getMessage());
                logger.error("Could not connect to destination service [Not Found] : " + e.getStackTrace());
            } else if (e instanceof HttpClientInstantiationException) {
                logger.error("Could not connect to destination service [Can't Create HttpClient] :" + e.getMessage());
                logger.error("Could not connect to destination service [Can't Create HttpClient] : " + e.getStackTrace());
            }
            throw new ODataException(ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED, REQUESTFAILURE, e);
        }
        finally {
            if (!isMediaRequest) {
                HttpClientUtils.closeQuietly((HttpResponse)this.httpResponse);
            }
        }
    }

    private URI getServiceUrl(String destinationName) throws URISyntaxException {
        URI servUri = destinationName != null ? this.getUri(DestinationAccessor.getDestination((String)destinationName).getUri(), ODataConnectivityUtil.withSeparator("/", this.servicePath), null) : new URI(this.servicePath);
        return servUri;
    }

    private void notifyQueryListeners(String destinationName) {
        for (ODataQueryListener ql : queryListeners) {
            try {
                if (destinationName != null) {
                    ql.onQuery(destinationName, this.servicePath, this.entity);
                    continue;
                }
                ql.onQuery(new URI(this.servicePath), this.entity);
            }
            catch (Exception e) {
                logger.error("Failure while invoking query listener of type " + ql.getClass(), (Throwable)e);
            }
        }
    }

    private HttpResponse loadEntriesFromDestination(String destinationName, URI serviceUrl, boolean isMediaRequest, HttpClient httpClient) throws URISyntaxException, ODataException, DestinationNotFoundException, DestinationAccessException, HttpClientInstantiationException, EdmException {
        if (this.useMetadata && this.entitymetadata == null) {
            URI uri = this.getUri(serviceUrl, ODataConnectivityUtil.withSeparator("/", METADATA), null);
            this.logRequestMeta(uri);
            try {
                this.loadMetadata(httpClient, uri, this.errorHandler);
            }
            catch (ODataException e) {
                throw new ODataException(ODataExceptionType.METADATA_FETCH_FAILED, "Failed to execute OData Metadata request.", e);
            }
        }
        HashMap<String, EdmType> typeMap = new HashMap<String, EdmType>();
        if (this.entitymetadata != null) {
            try {
                this.entityType = this.entitymetadata.getEntityType();
                for (String p : this.entityType.getPropertyNames()) {
                    typeMap.put(p, this.entityType.getProperty(p).getType());
                }
                if (this.keys != null) {
                    this.entity = this.entity + '(' + ODataConnectivityUtil.convertKeyValuesToString(this.keys, this.entityType) + ')';
                }
            }
            catch (EdmException e1) {
                throw new ODataException(ODataExceptionType.METADATA_PARSING_FAILED, "Error while parsing the metadata.", null);
            }
        }
        if (isMediaRequest) {
            this.entity = this.entity + "/$value";
        } else {
            this.requestQuery = this.oDataQueryResolver.getQuery(this.entityType);
        }
        String withSeperator = ODataConnectivityUtil.withSeparator("/", this.entity, this.requestLocalPath);
        URI uri = this.getUri(serviceUrl, withSeperator, this.requestQuery);
        uri = uri.resolve(this.getUrlPath(serviceUrl, withSeperator, this.requestQuery));
        this.logRequest(uri, destinationName);
        return new ODataRequestExecutor(httpClient, uri).errorHandler(this.errorHandler).headers(this.headers).execute();
    }

    private String getUrlPath(URI dest, String additionalPath, String query) {
        String adjustedPath = ODataConnectivityUtil.withSeparator("/", dest.getPath(), additionalPath);
        String adjustedQuery = ODataQuery.withSeparatorOmitFirst(SEPARATOR_QUERY, dest.getQuery(), query);
        if (adjustedQuery.isEmpty()) {
            adjustedQuery = null;
        } else {
            adjustedPath = adjustedPath + "?" + adjustedQuery;
        }
        return adjustedPath.replace(" ", "%20");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadMetadata(HttpClient httpClient, URI uri, ErrorResultHandler<?> errorResultHandler) throws ODataException {
        ClientEdm edm;
        block20: {
            edm = null;
            if (!this.cacheMetadata.booleanValue() && this.metadataFliePath != null && !this.metadataFliePath.toString().isEmpty()) {
                try (InputStream is = this.metadataFliePath.openStream();){
                    edm = ODataClient.newInstance().readMetadata(is, true).getEdm();
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Fetched metadata from the file %s", this.metadataFliePath.toString()));
                    }
                    break block20;
                }
                catch (EdmException e) {
                    throw new ODataException(ODataExceptionType.METADATA_PARSING_FAILED, "Failed to read metadata for \"" + this.entity + "\".", e);
                }
                catch (IOException | EntityProviderException e) {
                    logger.error("Failed to fetch the metadata", e);
                    throw new ODataException(ODataExceptionType.METADATA_FETCH_FAILED, "Failed to fetch the metadata \"" + this.entity + "\".", e);
                }
            }
            edm = this.metadataCache.getEdm(this.servicePath + "/$metadata", httpClient, this.destinationRelevantHeaders, errorResultHandler, this.cacheMetadata, this.metadataFliePath, this.cacheKey, this.isCacheRefresh);
        }
        try {
            this.entitymetadata = edm.getDefaultEntityContainer().getEntitySet(this.getEntityName(this.entity));
        }
        catch (EdmException e) {
            throw new ODataException(ODataExceptionType.METADATA_PARSING_FAILED, "Failed to read metadata for \"" + this.entity + "\".", e);
        }
        if (this.entitymetadata == null) {
            throw new ODataException(ODataExceptionType.METADATA_PARSING_FAILED, "No entity found in metadata for \"" + this.entity + "\".");
        }
    }

    private String getEntityName(String entitywkeys) {
        String result = entitywkeys;
        if (entitywkeys.contains("(")) {
            result = entitywkeys.substring(0, entitywkeys.indexOf("("));
        }
        return result;
    }

    private URI getUri(URI dest, String additionalPath, String query) throws URISyntaxException {
        String adjustedPath = ODataConnectivityUtil.withSeparator("/", dest.getPath(), additionalPath);
        String adjustedQuery = ODataQuery.withSeparatorOmitFirst(SEPARATOR_QUERY, dest.getQuery(), query);
        if (adjustedQuery.isEmpty()) {
            adjustedQuery = null;
        }
        return new URI(dest.getScheme(), dest.getUserInfo(), dest.getHost(), dest.getPort(), adjustedPath, adjustedQuery, dest.getFragment());
    }

    private void logRequest(URI uri, String destinationName) {
        logger.debug("Executing OData entity query to \"" + this.servicePath + "\" with entity \"" + this.entity + "\" and parameters \"" + (String)StringUtils.defaultIfEmpty((CharSequence)this.requestQuery, (CharSequence)"") + "\" on destination \"" + destinationName + "\". URI: " + uri + ".");
    }

    private void logRequestMeta(URI uri) {
        logger.debug("Executing OData metadata query to " + uri + ".");
    }

    private static String withSeparatorOmitFirst(String separator, String ... parts) {
        return StringUtils.removeStart((String)ODataConnectivityUtil.withSeparator(separator, parts), (String)separator);
    }

    public String toString() {
        String query = "";
        if (!this.isMediaRequest && !StringUtils.isEmpty((CharSequence)this.requestQuery)) {
            query = "?" + this.requestQuery;
        }
        if (!this.isMediaRequest && this.oDataQueryResolver != null) {
            try {
                query = "?" + this.oDataQueryResolver.getQuery(null);
            }
            catch (EdmException e) {
                return e.getMessage();
            }
        }
        return ODataConnectivityUtil.withSeparator("/", this.servicePath, this.entity, this.requestLocalPath) + query;
    }

    public String getMetadataQuery() {
        return ODataQuery.forMetadata(this.servicePath);
    }

    private String getMetadataQuery(String destinationName) {
        if (destinationName == null) {
            try {
                return ODataQuery.forMetadata(new URI(this.servicePath).getPath().toString());
            }
            catch (URISyntaxException e) {
                logger.error("Failure in metadata query population  " + e.getMessage());
                return null;
            }
        }
        return ODataQuery.forMetadata(this.servicePath);
    }

    public static String forMetadata(String path) {
        return ODataConnectivityUtil.withSeparator("/", path, METADATA);
    }

    protected String getEntity() {
        return this.entity;
    }

    protected String getServicePath() {
        return this.servicePath;
    }

    protected Map<String, Object> getKeys() {
        return this.keys;
    }

    protected ODataQueryBuilder.ODataQueryResolver getoDataQueryResolver() {
        return this.oDataQueryResolver;
    }

    protected ErrorResultHandler<?> getErrorHandler() {
        return this.errorHandler;
    }

    protected Map<String, String> getHeaders() {
        return this.headers;
    }

    @ConstructorProperties(value={"servicePath", "entity", "keys", "oDataQueryResolver", "errorHandler", "headers", "destinationRelevantHeaders", "useMetadata", "cacheMetadata", "metadataFliePath", "cacheKey"})
    protected ODataQuery(@NonNull String servicePath, @NonNull String entity, @Nullable Map<String, Object> keys, @NonNull ODataQueryBuilder.ODataQueryResolver oDataQueryResolver, @Nullable ErrorResultHandler<?> errorHandler, @Nullable Map<String, String> headers, @Nullable Map<String, String> destinationRelevantHeaders, boolean useMetadata, Boolean cacheMetadata, URL metadataFliePath, CacheKey cacheKey) {
        if (servicePath == null) {
            throw new NullPointerException("servicePath");
        }
        if (entity == null) {
            throw new NullPointerException("entity");
        }
        if (oDataQueryResolver == null) {
            throw new NullPointerException("oDataQueryResolver");
        }
        this.servicePath = servicePath;
        this.entity = entity;
        this.keys = keys;
        this.oDataQueryResolver = oDataQueryResolver;
        this.errorHandler = errorHandler;
        this.headers = headers;
        this.destinationRelevantHeaders = destinationRelevantHeaders;
        this.useMetadata = useMetadata;
        this.cacheMetadata = cacheMetadata;
        this.metadataFliePath = metadataFliePath;
        this.cacheKey = cacheKey;
    }
}

