/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity;

import java.util.Date;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class ODataType<T> {
    private final T value;
    private final EdmSimpleTypeKind typeKind;
    private final Class<T> type;

    private ODataType(T value, EdmSimpleTypeKind typeKind) {
        this.value = value;
        this.typeKind = typeKind;
        this.type = value.getClass();
    }

    public ODataType(T value) {
        this(value, null);
    }

    public static ODataType<String> of(String value) {
        return new ODataType<String>(value, EdmSimpleTypeKind.String);
    }

    public static ODataType<Long> of(Long value) {
        return new ODataType<Long>(value, EdmSimpleTypeKind.Int64);
    }

    public static ODataType<Integer> of(Integer value) {
        return new ODataType<Integer>(value, EdmSimpleTypeKind.Int32);
    }

    public static ODataType<Double> of(Double value) {
        return new ODataType<Double>(value, EdmSimpleTypeKind.Double);
    }

    public static ODataType<Float> of(Float value) {
        return new ODataType<Float>(value, EdmSimpleTypeKind.Double);
    }

    public static ODataType<Boolean> of(boolean value) {
        return new ODataType<Boolean>(value, EdmSimpleTypeKind.Boolean);
    }

    public static ODataType<LocalDate> of(LocalDate value) {
        return new ODataType<LocalDate>(value, EdmSimpleTypeKind.DateTime);
    }

    public static ODataType<LocalDateTime> of(LocalDateTime value) {
        return new ODataType<LocalDateTime>(value, EdmSimpleTypeKind.DateTime);
    }

    public static ODataType<DateTime> of(DateTime value) {
        return new ODataType<DateTime>(value, EdmSimpleTypeKind.DateTime);
    }

    public static ODataType<Date> of(Date value) {
        return new ODataType<Date>(value, EdmSimpleTypeKind.DateTime);
    }

    public static <T> ODataType<T> of(T value) {
        return new ODataType<T>(value);
    }

    public String toString() {
        return this.value.toString();
    }

    public T getValue() {
        return this.value;
    }

    public EdmSimpleTypeKind getTypeKind() {
        return this.typeKind;
    }

    public Class<T> getType() {
        return this.type;
    }
}

