/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity.batch;

import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.batch.BatchRequest;
import com.sap.cloud.sdk.odatav2.connectivity.batch.ChangeSet;
import com.sap.cloud.sdk.odatav2.connectivity.impl.BatchRequestImpl;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchRequestBuilder {
    private static Map<String, String> headers = new HashMap<String, String>();
    private final String servicePath;
    private List batch = new ArrayList();
    private CacheKey cacheKey;
    private boolean isCacheRefresh;
    private URL metadataFilePath;
    private boolean cacheMetadata;
    private ErrorResultHandler<?> errorHandler;
    private Map<String, String> destinationRelevantHeaders = new HashMap<String, String>();

    private BatchRequestBuilder(String servicePath) {
        this.servicePath = servicePath;
    }

    public BatchRequest build() {
        return new BatchRequestImpl(this.errorHandler, this.destinationRelevantHeaders, this.cacheMetadata, this.metadataFilePath, this.cacheKey, headers, this.isCacheRefresh, this.batch, this.servicePath);
    }

    public BatchRequestBuilder addQueryRequest(ODataQuery queryRequest) {
        this.batch.add(queryRequest);
        return this;
    }

    public BatchRequestBuilder addChangeSet(ChangeSet changeSet) {
        this.batch.add(changeSet);
        return this;
    }

    public static BatchRequestBuilder withService(String serviceName) {
        return new BatchRequestBuilder(serviceName);
    }

    public BatchRequestBuilder withHeader(String key, String value) {
        return this.withHeader(key, value, false);
    }

    public BatchRequestBuilder withHeader(String key, String value, boolean passInAllRequests) {
        if (passInAllRequests) {
            this.destinationRelevantHeaders.put(key, value);
        }
        if (key.equals("SAP-PASSPORT") && !passInAllRequests) {
            this.destinationRelevantHeaders.put(key, value);
        }
        headers.put(key, value);
        return this;
    }

    public BatchRequestBuilder withErrorHandler(ErrorResultHandler<?> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public BatchRequestBuilder enableMetadataCache() {
        this.cacheMetadata = true;
        return this;
    }

    public BatchRequestBuilder enableMetadataCache(CacheKey cacheKey) {
        this.cacheKey = cacheKey;
        this.cacheMetadata = true;
        return this;
    }

    public BatchRequestBuilder withCacheRefresh() {
        this.isCacheRefresh = true;
        return this;
    }

    public BatchRequestBuilder withMetadata(URL metadataFilePath) {
        this.metadataFilePath = metadataFilePath;
        return this;
    }
}

