/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity.cache.metadata;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantFacade;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataExceptionType;
import com.sap.cloud.sdk.odatav2.connectivity.cache.metadata.MetadataCache;
import com.sap.cloud.sdk.odatav2.connectivity.internal.ODataConnectivityUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.client.api.ODataClient;
import org.apache.olingo.odata2.client.api.edm.ClientEdm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaMetadataCache
implements MetadataCache {
    private static Logger logger = LoggerFactory.getLogger(GuavaMetadataCache.class);
    private static Cache<String, byte[]> cache = CacheBuilder.newBuilder().build();

    @Override
    public Edm getEdm(final String URL2, final HttpClient httpClient, final Map<String, String> headers, final ErrorResultHandler<?> errorHandler, Boolean getMetadataFromCache) throws ODataException {
        byte[] b = null;
        if (getMetadataFromCache.booleanValue()) {
            try {
                b = (byte[])cache.get((Object)URL2, (Callable)new Callable<byte[]>(){

                    @Override
                    public byte[] call() throws Exception {
                        byte[] byArray;
                        HttpResponse httpResponse = null;
                        try {
                            HttpGet httpGet = new HttpGet(URL2);
                            if (headers != null) {
                                for (Map.Entry e : headers.entrySet()) {
                                    httpGet.addHeader((String)e.getKey(), (String)e.getValue());
                                }
                            }
                            httpResponse = httpClient.execute((HttpUriRequest)httpGet);
                            InputStream metadatastream = null;
                            ODataConnectivityUtil.checkHttpStatus(httpResponse, errorHandler);
                            metadatastream = httpResponse.getEntity().getContent();
                            byArray = IOUtils.toByteArray((InputStream)metadatastream);
                        }
                        catch (Exception e) {
                            try {
                                logger.error("Error occurred during populating metadata : " + e);
                                throw e;
                            }
                            catch (Throwable throwable) {
                                HttpClientUtils.closeQuietly(httpResponse);
                                throw throwable;
                            }
                        }
                        HttpClientUtils.closeQuietly((HttpResponse)httpResponse);
                        return byArray;
                    }
                });
                ByteArrayInputStream is = new ByteArrayInputStream(b);
                return ODataClient.newInstance().readMetadata((InputStream)is, true).getEdm();
            }
            catch (Exception e) {
                logger.error("Error occurred while fetching edm from cache " + e);
                throw new ODataException(ODataExceptionType.METADATA_FETCH_FAILED, "Error fetching the metadata", e);
            }
        }
        try {
            return this.getEdm(URL2, httpClient, headers, errorHandler);
        }
        catch (ODataException e) {
            logger.error("Error occurred during populating metadata : " + e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Error occurred during populating metadata : " + e);
            throw new ODataException(ODataExceptionType.METADATA_FETCH_FAILED, "Error fetching the metadata", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Edm getEdm(final String URL2, final HttpClient httpClient, final Map<String, String> headers, final ErrorResultHandler<?> errorHandler, Boolean getMetadataFromCache, final URL metadataFilePath, CacheKey cacheKey, Boolean isCacheRefresh) throws ODataException {
        byte[] b = null;
        if (cacheKey == null) {
            cacheKey = this.getCacheKey(URL2);
        } else if (cacheKey != null) {
            cacheKey.append(new Object[]{URL2});
        }
        if (isCacheRefresh.booleanValue()) {
            this.removeEntry(cacheKey);
        }
        if (getMetadataFromCache.booleanValue()) {
            try {
                b = (byte[])cache.get((Object)cacheKey.toString(), (Callable)new Callable<byte[]>(){

                    @Override
                    public byte[] call() throws Exception {
                        return GuavaMetadataCache.this.cacheEdm(URL2, httpClient, headers, errorHandler, metadataFilePath);
                    }
                });
                logger.debug("Fetched the metadata from the cache");
                ByteArrayInputStream is = new ByteArrayInputStream(b);
                return ODataClient.newInstance().readMetadata((InputStream)is, true).getEdm();
            }
            catch (Exception e) {
                logger.error("Error occurred while fetching edm from cache ", (Throwable)e);
                throw new ODataException(ODataExceptionType.METADATA_FETCH_FAILED, "Error fetching the metadata", e);
            }
        }
        if (metadataFilePath != null) {
            try (InputStream metadatastream = metadataFilePath.openStream();){
                logger.debug("Fetched the metadata from file.");
                ClientEdm clientEdm = ODataClient.newInstance().readMetadata(metadatastream, true).getEdm();
                return clientEdm;
            }
            catch (IOException | EdmException | EntityProviderException e) {
                logger.error("Error occurred while populating metadata : ", e);
                throw new ODataException(ODataExceptionType.METADATA_FETCH_FAILED, "Error fetching the metadata", e);
            }
        }
        try {
            return this.getEdm(URL2, httpClient, headers, errorHandler);
        }
        catch (ODataException e) {
            logger.error("Error occurred while populating metadata: ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Error occurred while populating metadata : ", (Throwable)e);
            throw new ODataException(ODataExceptionType.METADATA_FETCH_FAILED, "Error fetching the metadata", e);
        }
    }

    @Override
    public Edm getEdm(String URL2, HttpClient httpClient, Map<String, String> headers, ErrorResultHandler<?> errorHandler, Boolean getMetadataFromCache, URL metadataFilePath) throws ODataException {
        return this.getEdm(URL2, httpClient, headers, errorHandler, getMetadataFromCache, metadataFilePath, null, null);
    }

    /*
     * Exception decompiling
     */
    private byte[] cacheEdm(String URL, HttpClient httpClient, Map<String, String> headers, ErrorResultHandler<?> errorHandler, URL metadataFilePath) throws ODataException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Edm getEdm(String URL2, HttpClient httpClient, Map<String, String> headers, ErrorResultHandler<?> errorHandler) throws ClientProtocolException, IOException, ODataException, EdmException, EntityProviderException {
        HttpGet httpGet = new HttpGet(URL2);
        if (headers != null) {
            for (Map.Entry<String, String> e : headers.entrySet()) {
                httpGet.addHeader(e.getKey(), e.getValue());
            }
        }
        HttpResponse httpResponse = null;
        httpResponse = httpClient.execute((HttpUriRequest)httpGet);
        InputStream metadatastream = null;
        ODataConnectivityUtil.checkHttpStatus(httpResponse, errorHandler);
        try {
            metadatastream = httpResponse.getEntity().getContent();
            logger.debug("Fetched metadata from service.");
            ClientEdm clientEdm = ODataClient.newInstance().readMetadata(metadatastream, true).getEdm();
            return clientEdm;
        }
        catch (EntityProviderException e) {
            logger.error("Error occurred during populating metadata : ", (Throwable)e);
            throw e;
        }
        finally {
            HttpClientUtils.closeQuietly((HttpResponse)httpResponse);
        }
    }

    @Override
    public void removeEntry(String completeUrl) {
        cache.invalidate((Object)completeUrl);
    }

    @Override
    public void removeEntry(CacheKey cacheKey) {
        cache.invalidate((Object)cacheKey);
    }

    private CacheKey getCacheKey(String metadataUrl) {
        CacheKey cacheKey = null;
        TenantFacade tenantFacade = TenantAccessor.getTenantFacade();
        cacheKey = tenantFacade != null && tenantFacade.tryGetCurrentTenant() != null && tenantFacade.tryGetCurrentTenant().isSuccess() && tenantFacade.tryGetCurrentTenant().get() != null ? CacheKey.ofTenantIsolation() : CacheKey.ofNoIsolation();
        if (cacheKey != null) {
            cacheKey.append(new Object[]{metadataUrl});
        }
        if (logger.isDebugEnabled()) {
            logger.debug("*******CACHE KEY *********** : {} ", (Object)cacheKey.toString());
        }
        return cacheKey;
    }

    @Override
    public void clearCache() {
        cache.invalidateAll();
    }
}

