/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity.filter;

import com.sap.cloud.sdk.odatav2.connectivity.FilterExpression;
import com.sap.cloud.sdk.odatav2.connectivity.ODataProperty;
import com.sap.cloud.sdk.odatav2.connectivity.ODataType;
import com.sap.cloud.sdk.odatav2.connectivity.filter.BaseFilterValue;
import com.sap.cloud.sdk.odatav2.connectivity.filter.FilterFunctions;
import com.sap.cloud.sdk.odatav2.connectivity.filter.FilterHelperUtil;

public class BoolValue
implements BaseFilterValue {
    private FilterFunctions.FUNCTIONS operator;
    private String leftProperty = null;
    private ODataType operand = null;

    public BoolValue(FilterFunctions.FUNCTIONS function, ODataProperty property, ODataType<String> operand) {
        this.operand = operand;
        this.operator = function;
        this.leftProperty = property.getField();
    }

    public FilterExpression isFalse() {
        return new FilterExpression(this.toString(), "eq", ODataType.of(false), true);
    }

    public FilterExpression isTrue() {
        return new FilterExpression(this.toString(), "eq", ODataType.of(true), true);
    }

    public String toString() {
        String result = null;
        switch (this.operator) {
            case ENDSWITH: 
            case STARTSWITH: {
                result = FilterHelperUtil.buildBinaryFunc(this.operator.toString(), this.leftProperty, this.operand);
                break;
            }
            case SUBSTRINGOF: {
                result = FilterHelperUtil.buildSubstringOfFunc(this.operator.toString(), this.operand, this.leftProperty.toString());
                break;
            }
        }
        return result;
    }

    @Override
    public String getStringValue() {
        return this.toString();
    }
}

