/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity.filter;

import com.sap.cloud.sdk.odatav2.connectivity.FilterExpression;
import com.sap.cloud.sdk.odatav2.connectivity.ODataType;
import com.sap.cloud.sdk.odatav2.connectivity.filter.BaseFilterValue;
import com.sap.cloud.sdk.odatav2.connectivity.filter.FilterConverterHelper;
import com.sap.cloud.sdk.odatav2.connectivity.filter.FilterFunctionException;
import com.sap.cloud.sdk.odatav2.connectivity.filter.FilterFunctions;
import com.sap.cloud.sdk.service.prov.api.filter.BinaryExpressionNode;
import com.sap.cloud.sdk.service.prov.api.filter.Expression;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionNode;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionOperatorTypes;
import com.sap.cloud.sdk.service.prov.api.filter.FunctionNode;
import com.sap.cloud.sdk.service.prov.api.filter.LiteralNode;
import com.sap.cloud.sdk.service.prov.api.filter.PropertyNode;
import com.sap.cloud.sdk.service.prov.api.filter.UnaryExpressionNode;
import java.util.Stack;

public class FilterExpressionConverter {
    private static Stack<OperatorNode> operatorStack = new Stack();
    private static Stack<OperandNode> operandStack = new Stack();
    private static final int BINARYOPERAND = 2;
    private static final int UNARYOPERAND = 1;

    public static FilterExpression convertTo(Expression filterExp) throws FilterFunctionException {
        FilterExpression result = null;
        if (filterExp instanceof ExpressionNode) {
            ExpressionNode filterNode = (ExpressionNode)filterExp;
            if (filterNode.getKind().equals((Object)ExpressionOperatorTypes.NODE_KIND.BINARY)) {
                operatorStack.push(new OperatorNode(((BinaryExpressionNode)filterNode).getOperator(), OPERATORKIND.BINARY));
                FilterExpressionConverter.convertTo((Expression)((BinaryExpressionNode)filterNode).getFirstChild());
                FilterExpressionConverter.convertTo((Expression)((BinaryExpressionNode)filterNode).getSecondChild());
                FilterExpression fxp = FilterExpressionConverter.processStacksToCreateExpression(OPERATORKIND.BINARY, 2);
                operandStack.push(new OperandNode(fxp, OPERANDKIND.EXPRESSION));
            } else if (filterNode.getKind() == ExpressionOperatorTypes.NODE_KIND.PROPERTY) {
                operandStack.push(new OperandNode(((PropertyNode)filterNode).getPath(), OPERANDKIND.PROPERTY));
            } else if (filterNode.getKind() == ExpressionOperatorTypes.NODE_KIND.LITERAL) {
                operandStack.push(new OperandNode(((LiteralNode)filterNode).getValue(), OPERANDKIND.LITERAL));
            } else if (filterNode.getKind() == ExpressionOperatorTypes.NODE_KIND.UNARY) {
                operatorStack.push(new OperatorNode(((UnaryExpressionNode)filterNode).getOperator(), OPERATORKIND.UNARY));
                FilterExpressionConverter.convertTo((Expression)((UnaryExpressionNode)filterNode).getChild());
                FilterExpression fxp = FilterExpressionConverter.processStacksToCreateExpression(OPERATORKIND.UNARY, 1);
                operandStack.push(new OperandNode(fxp, OPERANDKIND.EXPRESSION));
            } else if (filterNode.getKind() == ExpressionOperatorTypes.NODE_KIND.FUNCTION) {
                OperandNode operand;
                FunctionNode fnode = (FunctionNode)filterNode;
                operatorStack.push(new OperatorNode(fnode.getFunctionName(), OPERATORKIND.FUNCTION));
                for (ExpressionNode fnodeParam : fnode.getParameters()) {
                    FilterExpressionConverter.convertTo((Expression)fnodeParam);
                }
                String func = fnode.getFunctionName();
                if (func.equalsIgnoreCase(FilterFunctions.FUNCTIONS.STARTSWITH.name()) || func.equalsIgnoreCase(FilterFunctions.FUNCTIONS.ENDSWITH.name()) || func.equalsIgnoreCase(FilterFunctions.FUNCTIONS.SUBSTRINGOF.name())) {
                    FilterExpression exp = FilterExpressionConverter.processStacksToCreateFilterFunctionExp(fnode.getParameters().size());
                    operand = new OperandNode(exp, OPERANDKIND.FUNCTION);
                } else {
                    String filterFunc = FilterExpressionConverter.processStacksToCreateFilterFunction(fnode.getParameters().size());
                    operand = new OperandNode(filterFunc, OPERANDKIND.FUNCTION);
                }
                operandStack.push(operand);
            }
            if (operatorStack.isEmpty() && operandStack.size() == 1) {
                result = (FilterExpression)operandStack.pop().getKey();
            }
        }
        return result;
    }

    private static FilterExpression processStacksToCreateFilterFunctionExp(int size) {
        OperandNode[] nodes = new OperandNode[size];
        for (int i = 0; i < size; ++i) {
            nodes[i] = operandStack.pop();
        }
        OperatorNode operator = operatorStack.pop();
        String property = "";
        Object op1 = null;
        Object op2 = null;
        if (operator.operatorValue.equalsIgnoreCase(FilterFunctions.FUNCTIONS.SUBSTRINGOF.name())) {
            property = nodes[0].getKind() == OPERANDKIND.PROPERTY ? nodes[0].getKey().toString() : null;
            Object object = op1 = nodes[1].getKind() == OPERANDKIND.LITERAL ? nodes[1].getKey() : null;
        }
        if (op1 == null) {
            property = FilterExpressionConverter.getOperandAsProperty(nodes);
            op1 = FilterExpressionConverter.getOperandasFirstOperand(nodes);
            op2 = FilterExpressionConverter.getOperandAsSecondOperand(nodes);
        }
        if (FilterConverterHelper.isStringFunction(operator.getOperatorValue())) {
            return FilterConverterHelper.createV2StringFunctionExpression(operator.operatorValue, property, op1, op2, nodes.length);
        }
        return null;
    }

    private static String processStacksToCreateFilterFunction(int size) throws FilterFunctionException {
        OperandNode[] nodes = new OperandNode[size];
        for (int i = 0; i < size; ++i) {
            nodes[i] = operandStack.pop();
        }
        OperatorNode operator = operatorStack.pop();
        return FilterExpressionConverter.createV2FilterFunction(nodes, operator).getStringValue();
    }

    private static FilterExpression processStacksToCreateExpression(OPERATORKIND kind, int operandCount) {
        OperandNode[] node = new OperandNode[operandCount];
        OperatorNode operator = null;
        FilterExpression v2Exp = null;
        switch (kind) {
            case BINARY: {
                node[0] = operandStack.pop();
                node[1] = operandStack.pop();
                operator = operatorStack.pop();
                v2Exp = FilterExpressionConverter.createV2FilterExpression(node[0], node[1], operator);
                break;
            }
            case UNARY: {
                operatorStack.pop();
                node[0] = operandStack.pop();
                FilterExpression exp = (FilterExpression)node[0].getKey();
                v2Exp = FilterExpression.not(exp);
                break;
            }
        }
        return v2Exp;
    }

    private static BaseFilterValue createV2FilterFunction(OperandNode[] nodes, OperatorNode operator) throws FilterFunctionException {
        String property = "";
        Object op1 = null;
        Object op2 = null;
        property = FilterExpressionConverter.getOperandAsProperty(nodes);
        op1 = FilterExpressionConverter.getOperandasFirstOperand(nodes);
        op2 = FilterExpressionConverter.getOperandAsSecondOperand(nodes);
        if (FilterConverterHelper.isStringFunction(operator.getOperatorValue())) {
            return FilterConverterHelper.createV2StringFunction(operator.operatorValue, property, op1, op2, nodes.length);
        }
        if (FilterConverterHelper.isMathFunction(operator.getOperatorValue())) {
            return FilterConverterHelper.createV2MathFunction(operator.operatorValue, property, op1);
        }
        if (FilterConverterHelper.isDateFunction(operator.getOperatorValue())) {
            return FilterConverterHelper.createV2DateFunction(operator.operatorValue, property, op1);
        }
        throw new FilterFunctionException("Filter function is not supported :" + operator.operatorValue);
    }

    private static String getOperandAsProperty(OperandNode[] nodes) {
        if (nodes.length == 3) {
            return nodes[2].getKind() == OPERANDKIND.PROPERTY ? nodes[2].getKey().toString() : null;
        }
        if (nodes.length == 2) {
            return nodes[1].getKind() == OPERANDKIND.PROPERTY ? nodes[1].getKey().toString() : null;
        }
        return nodes[0].getKind() == OPERANDKIND.PROPERTY ? nodes[0].getKey().toString() : null;
    }

    private static Object getOperandasFirstOperand(OperandNode[] nodes) {
        if (nodes.length == 3) {
            return nodes[1].getKind() == OPERANDKIND.LITERAL ? nodes[1].getKey() : null;
        }
        if (nodes.length == 2) {
            return nodes[0].getKind() == OPERANDKIND.LITERAL ? nodes[0].getKey() : null;
        }
        return null;
    }

    private static Object getOperandAsSecondOperand(OperandNode[] nodes) {
        if (nodes.length == 3) {
            return nodes[0].getKind() == OPERANDKIND.LITERAL ? nodes[0].getKey() : null;
        }
        return null;
    }

    private static FilterExpression createV2FilterExpression(OperandNode node1, OperandNode node2, OperatorNode operator) {
        FilterExpression result = null;
        boolean isRightExpressionNode = false;
        FilterExpression left = null;
        FilterExpression right = null;
        Object literalValue = null;
        String propertyValue = "";
        boolean isFunction = false;
        switch (node1.getKind()) {
            case EXPRESSION: {
                isRightExpressionNode = true;
                right = (FilterExpression)node1.getKey();
                break;
            }
            case LITERAL: {
                literalValue = node1.getKey();
                break;
            }
            case PROPERTY: {
                propertyValue = node1.getKey().toString();
                break;
            }
            case FUNCTION: {
                propertyValue = node1.getKey().toString();
                isFunction = true;
                break;
            }
        }
        switch (node2.getKind()) {
            case EXPRESSION: {
                left = (FilterExpression)node2.getKey();
                break;
            }
            case LITERAL: {
                literalValue = node2.getKey();
                break;
            }
            case PROPERTY: {
                propertyValue = node2.getKey().toString();
                break;
            }
            case FUNCTION: {
                propertyValue = node2.getKey().toString();
                isFunction = true;
                break;
            }
        }
        if (isRightExpressionNode && left != null) {
            if (operator.getOperatorValue().equals("AND")) {
                result = left.and(right);
            } else if (operator.getOperatorValue().equals("OR")) {
                result = left.or(right);
            }
        } else {
            result = isFunction ? new FilterExpression(propertyValue, operator.getOperatorValue().toLowerCase(), ODataType.of(literalValue), true) : new FilterExpression(propertyValue, operator.getOperatorValue().toLowerCase(), ODataType.of(literalValue));
        }
        return result;
    }

    private static class OperatorNode {
        private String operatorValue;
        private OPERATORKIND kind;

        public OperatorNode(String operator, OPERATORKIND opkind) {
            this.operatorValue = operator;
            this.kind = opkind;
        }

        public String getOperatorValue() {
            return this.operatorValue;
        }

        public OPERATORKIND getKind() {
            return this.kind;
        }
    }

    private static class OperandNode {
        private Object key;
        private OPERANDKIND kind;

        public OperandNode(Object path, OPERANDKIND opKind) {
            this.key = path;
            this.kind = opKind;
        }

        public Object getKey() {
            return this.key;
        }

        public OPERANDKIND getKind() {
            return this.kind;
        }
    }

    private static enum OPERATORKIND {
        BINARY,
        UNARY,
        FUNCTION;

    }

    private static enum OPERANDKIND {
        PROPERTY,
        LITERAL,
        EXPRESSION,
        FUNCTION;

    }
}

