/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity.filter;

import com.sap.cloud.sdk.odatav2.connectivity.FilterExpression;
import com.sap.cloud.sdk.odatav2.connectivity.ODataProperty;
import com.sap.cloud.sdk.odatav2.connectivity.ODataType;
import com.sap.cloud.sdk.odatav2.connectivity.filter.BaseFilterValue;
import com.sap.cloud.sdk.odatav2.connectivity.filter.FilterFunctions;
import com.sap.cloud.sdk.odatav2.connectivity.filter.FilterHelperUtil;
import com.sap.cloud.sdk.odatav2.connectivity.filter.LogicalOperators;

public class StringValue
implements LogicalOperators,
BaseFilterValue {
    private FilterFunctions.FUNCTIONS operator;
    private String leftProperty = null;
    private ODataType operand = null;
    private Integer length = null;
    private Integer position = null;
    private String find = null;
    private String replace = null;

    public StringValue(FilterFunctions.FUNCTIONS operator, ODataProperty property, ODataType operand) {
        this.leftProperty = FilterHelperUtil.validateParam(property.getField());
        this.operator = operator;
        this.operand = operand;
    }

    public StringValue(FilterFunctions.FUNCTIONS operator, StringValue property, ODataType operand) {
        this.leftProperty = FilterHelperUtil.validateParam(property.toString());
        this.operator = operator;
        this.operand = operand;
    }

    public StringValue(FilterFunctions.FUNCTIONS operator, ODataProperty property, Integer pos, Integer length) {
        this.operator = operator;
        this.leftProperty = FilterHelperUtil.validateParam(property.getField());
        this.position = pos;
        this.length = length;
    }

    public StringValue(FilterFunctions.FUNCTIONS operator, StringValue property, Integer pos, Integer length) {
        this.operator = operator;
        this.leftProperty = FilterHelperUtil.validateParam(property.toString());
        this.position = pos;
        this.length = length;
    }

    public StringValue(FilterFunctions.FUNCTIONS operator, ODataProperty property, String find, String replace) {
        this.operator = operator;
        this.leftProperty = FilterHelperUtil.validateParam(property.getField());
        this.find = find;
        this.replace = replace;
    }

    public StringValue(FilterFunctions.FUNCTIONS operator, StringValue property, String find, String replace) {
        this.operator = operator;
        this.leftProperty = FilterHelperUtil.validateParam(property.toString());
        this.find = find;
        this.replace = replace;
    }

    @Override
    public FilterExpression eq(ODataType right) {
        return new FilterExpression(this.toString(), "eq", right, true);
    }

    @Override
    public FilterExpression ne(ODataType right) {
        return new FilterExpression(this.toString(), "ne", right, true);
    }

    @Override
    public FilterExpression gt(ODataType right) {
        return new FilterExpression(this.toString(), "gt", right, true);
    }

    @Override
    public FilterExpression ge(ODataType right) {
        return new FilterExpression(this.toString(), "ge", right, true);
    }

    @Override
    public FilterExpression le(ODataType right) {
        return new FilterExpression(this.toString(), "le", right, true);
    }

    @Override
    public FilterExpression lt(ODataType right) {
        return new FilterExpression(this.toString(), "lt", right, true);
    }

    public String toString() {
        String result = null;
        switch (this.operator) {
            case CONCAT: {
                result = FilterHelperUtil.buildBinaryFunc(this.operator.toString(), this.leftProperty, this.operand);
                break;
            }
            case SUBSTRING: {
                if (this.length != null) {
                    result = FilterHelperUtil.buildTernaryFunc(this.operator.toString(), this.leftProperty, ODataType.of(this.position), ODataType.of(this.length));
                    break;
                }
                result = FilterHelperUtil.buildBinaryFunc(this.operator.toString(), this.leftProperty, ODataType.of(this.position));
                break;
            }
            case REPLACE: {
                result = FilterHelperUtil.buildTernaryFunc(this.operator.toString(), this.leftProperty, ODataType.of(this.find), ODataType.of(this.replace));
                break;
            }
            case TOLOWER: 
            case TOUPPER: 
            case TRIM: {
                result = FilterHelperUtil.buildUnaryFunc(this.operator.toString(), this.leftProperty);
                break;
            }
        }
        return result;
    }

    @Override
    public String getStringValue() {
        return this.toString();
    }
}

