/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.odatav2.connectivity.internal;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.internal.DefaultErrorResultHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ErpErrorResultHandler
extends DefaultErrorResultHandler<ErpODataException> {
    private static final Logger logger = CloudLoggerFactory.getLogger(ErpErrorResultHandler.class);
    public static final String MISSING_JSON_XML = "Not an XML";
    private static final String FEATURE_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String FEATURE_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";

    @Override
    protected Class<ErpODataException> getExceptionType() {
        return ErpODataException.class;
    }

    private Document getXmlDocument(String message) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature(FEATURE_EXTERNAL_GENERAL_ENTITIES, false);
        factory.setFeature(FEATURE_EXTERNAL_PARAMETER_ENTITIES, false);
        factory.setExpandEntityReferences(false);
        return factory.newDocumentBuilder().parse(new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public ErpODataException createError(String message, Object origin, int httpStatusCode) {
        ErpODataException exception;
        boolean isXml = StringUtils.startsWith((CharSequence)message, (CharSequence)"<");
        boolean isJson = StringUtils.startsWith((CharSequence)message, (CharSequence)"{");
        if (StringUtils.isEmpty((CharSequence)message)) {
            exception = new ErpODataException();
        } else if (isXml) {
            exception = new ErpODataException();
            try {
                Document doc = this.getXmlDocument(message);
                exception.setMessage(doc.getDocumentElement().getTextContent());
                Node elementCode = doc.getElementsByTagName("code").item(0);
                if (elementCode == null) {
                    exception.setMessage(message);
                } else {
                    exception.setCode(elementCode.getTextContent());
                }
                exception.setParsedXml(true);
            }
            catch (Exception e) {
                logger.warn("Could not deserialize XML document.", (Throwable)e);
            }
        } else if (isJson) {
            exception = (ErpODataException)super.createError(message, origin, httpStatusCode);
        } else {
            exception = new ErpODataException();
            exception.setMessage(MISSING_JSON_XML);
        }
        if (origin instanceof ODataQuery) {
            exception.setQuery((ODataQuery)origin);
        }
        return exception;
    }

    public static class ErpODataException
    extends ODataException {
        private static final long serialVersionUID = 6880772175494689747L;
        private boolean parsedXml = false;
        private transient ODataQuery query;
        private String code;

        public String getMessageClass() {
            String[] parts = StringUtils.split((String)this.code, (String)"/", (int)2);
            if (parts != null && parts.length == 2) {
                return parts[0];
            }
            return null;
        }

        public String getMessageNumber() {
            String[] parts = StringUtils.split((String)this.code, (String)"/", (int)2);
            if (parts != null && parts.length == 2) {
                return parts[1];
            }
            return null;
        }

        public void setParsedXml(boolean parsedXml) {
            this.parsedXml = parsedXml;
        }

        public ODataQuery getQuery() {
            return this.query;
        }

        public void setQuery(ODataQuery query) {
            this.query = query;
        }

        @Override
        public String getCode() {
            return this.code;
        }

        @Override
        public void setCode(String code) {
            this.code = code;
        }
    }
}

