/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.annotation.repository;

import com.sap.cloud.sdk.service.prov.annotation.repository.AnnotatedClassMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationRepository<T> {
    private static Logger log = LoggerFactory.getLogger(AnnotationRepository.class);
    private static AnnotationRepository _instance = null;
    private static Map<String, List<AnnotatedClassMethod<?>>> annoClassMethodMap = new HashMap();

    private AnnotationRepository() {
    }

    public static synchronized AnnotationRepository<?> getInstance() {
        if (_instance == null) {
            _instance = new AnnotationRepository();
        }
        if (log.isDebugEnabled()) {
            log.debug("AnnotationRepository Instance :" + _instance);
        }
        return _instance;
    }

    public List<AnnotatedClassMethod<?>> getClassMethodListForAnnotation(String annotationName) {
        if (log.isDebugEnabled()) {
            log.debug("getClassMethodListForAnnotation :" + annotationName + " " + annoClassMethodMap.get(annotationName));
        }
        return annoClassMethodMap.get(annotationName);
    }

    public synchronized void registerAnnotationClassMethod(String annotationName, AnnotatedClassMethod<?> annoClassMthod) {
        if (log.isDebugEnabled()) {
            log.debug("registerAnnotationClassMethod :" + annotationName + " " + annoClassMthod);
        }
        if (annoClassMethodMap.containsKey(annotationName)) {
            List<AnnotatedClassMethod<?>> existingList = annoClassMethodMap.get(annotationName);
            existingList.add(annoClassMthod);
            annoClassMethodMap.put(annotationName, existingList);
        } else {
            ArrayList newList = new ArrayList();
            newList.add(annoClassMthod);
            annoClassMethodMap.put(annotationName, newList);
        }
    }
}

