/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.sap.cloud.sdk.service.prov.api.EntityDataBuilder;
import com.sap.cloud.sdk.service.prov.api.exception.DataConversionException;
import com.sap.cloud.sdk.service.prov.api.internal.CSNUtil;
import com.sap.cloud.sdk.service.prov.api.internal.DefaultEntityDataBuilder;
import com.sap.cloud.sdk.service.prov.api.util.PojoUtil;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class EntityData
implements Cloneable {
    protected abstract Object getPropertyValue(String var1);

    public abstract boolean contains(String var1);

    public abstract Object getAssociationValue(String var1);

    public abstract Map<String, Object> getAssociations();

    protected static Object cloneProperty(Object property) {
        if (property instanceof Calendar) {
            return ((Calendar)property).clone();
        }
        if (property instanceof Timestamp) {
            return Timestamp.from(((Timestamp)property).toInstant());
        }
        if (property instanceof Time) {
            return new Time(((Time)property).getTime());
        }
        if (property instanceof Date) {
            return new Date(((Date)property).getTime());
        }
        if (property instanceof java.util.Date) {
            return new java.util.Date(((java.util.Date)property).getTime());
        }
        if (property instanceof Map) {
            return EntityData.cloneMap((Map)property);
        }
        if (property instanceof List) {
            return EntityData.cloneList((List)property);
        }
        return property;
    }

    protected static Object cloneMap(Map<String, Object> property) {
        HashMap<String, Object> cloned = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : property.entrySet()) {
            cloned.put(entry.getKey(), EntityData.cloneProperty(property.get(entry.getKey())));
        }
        return cloned;
    }

    protected static Object cloneList(List<Map<String, Object>> mapList) {
        ArrayList<Map> cloned = new ArrayList<Map>();
        for (Map<String, Object> map : mapList) {
            cloned.add((Map)EntityData.cloneMap(map));
        }
        return cloned;
    }

    public Object getElementValue(String name) {
        return EntityData.cloneProperty(this.getPropertyValue(name));
    }

    public static EntityDataBuilder getBuilder() {
        return new DefaultEntityDataBuilder();
    }

    public static EntityDataBuilder getBuilder(EntityData entityData) {
        return new DefaultEntityDataBuilder(entityData);
    }

    public static EntityData createFromMap(Map<String, Object> propertiesMap, List<String> keys, String entityName) {
        Map cloned = (Map)EntityData.cloneMap(propertiesMap);
        DefaultEntityDataBuilder entityDataBuilder = new DefaultEntityDataBuilder();
        cloned.forEach((key, value) -> entityDataBuilder.addElement((String)key, value));
        if (keys != null) {
            for (String key2 : keys) {
                entityDataBuilder.addKeyElement(key2, propertiesMap.get(key2));
            }
        }
        return entityDataBuilder.buildEntityData(entityName);
    }

    public static EntityData createFromDeepMap(Map<String, Object> propertiesMap, Map<String, List<String>> keys, String entityName) {
        int index = entityName.lastIndexOf(46);
        String serviceName = entityName.substring(0, index);
        String parentEntityName = entityName.substring(index + 1, entityName.length());
        return EntityData.createFromDeepMap(serviceName, propertiesMap, keys, parentEntityName, parentEntityName);
    }

    private static EntityData createFromDeepMap(String serviceName, Map<String, Object> propertiesMap, Map<String, List<String>> keys, String entityName, String associationName) {
        Map cloned = (Map)EntityData.cloneMap(propertiesMap);
        DefaultEntityDataBuilder entityDataBuilder = new DefaultEntityDataBuilder();
        cloned.forEach((key, value) -> {
            if (value instanceof Map) {
                String associatedEntity = CSNUtil.getEntityName(serviceName, entityName, key);
                if (associatedEntity == null || "".equals(associatedEntity.trim())) throw new IllegalStateException("Association with the name " + key + " is not found.");
                entityDataBuilder.addAssociationElement((String)key, EntityData.createFromDeepMap(serviceName, (Map)value, keys, associatedEntity, key));
                return;
            } else if (value instanceof List) {
                String associatedEntity = CSNUtil.getEntityName(serviceName, entityName, key);
                List valueList = (List)value;
                ArrayList<EntityData> edList = new ArrayList<EntityData>();
                for (Map valueMap : valueList) {
                    edList.add(EntityData.createFromDeepMap(serviceName, valueMap, keys, associatedEntity, key));
                }
                entityDataBuilder.addAssociationElement((String)key, edList);
                return;
            } else {
                entityDataBuilder.addElement((String)key, value);
            }
        });
        if (keys.get(associationName) != null) {
            for (String key2 : keys.get(associationName)) {
                entityDataBuilder.addKeyElement(key2, propertiesMap.get(key2));
            }
        }
        return entityDataBuilder.buildEntityData(associationName);
    }

    public abstract Map<String, Object> asMap();

    public static EntityData createFrom(Object data, String entityName) {
        Map<String, Object> tempdata = EntityData.getMapFromSinglePojo(data);
        List<String> keys = PojoUtil.getKeyProperties(data);
        if (keys.isEmpty()) {
            throw new DataConversionException("The POJO class is not having any keys");
        }
        Map copyData = (Map)EntityData.cloneMap(tempdata);
        if (copyData.size() > 0) {
            return EntityData.createFromMap(copyData, keys, entityName);
        }
        return null;
    }

    private static Map<String, Object> getMapFromSinglePojo(Object pojoData) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        Map pojoInMap = (Map)mapper.convertValue(pojoData, HashMap.class);
        return pojoInMap;
    }

    public abstract <T> T as(Class<T> var1) throws DataConversionException;

    public abstract Map<String, Object> getMap();
}

