/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.filter;

import com.sap.cloud.sdk.service.prov.api.filter.BinaryExpressionNode;
import com.sap.cloud.sdk.service.prov.api.filter.Expression;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionNode;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionOperatorTypes;
import com.sap.cloud.sdk.service.prov.api.filter.FunctionNode;
import com.sap.cloud.sdk.service.prov.api.filter.UnaryExpressionNode;
import java.util.ArrayList;
import java.util.List;

public class ExpressionAPIUtility {
    private List<ExpressionNode> nodes = null;

    public List<ExpressionNode> getLeafUnits(Expression filterTreeNode) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<ExpressionNode>();
        }
        this.traverseFilterTree((ExpressionNode)filterTreeNode, true);
        return this.nodes;
    }

    private void traverseFilterTree(ExpressionNode filterTreeNode, boolean leafUnitFlag) {
        List<ExpressionNode> childrenNodes = this.getChildren(filterTreeNode);
        if (leafUnitFlag) {
            if (this.isLeafUnit(childrenNodes)) {
                this.nodes.add(filterTreeNode);
            }
        } else {
            this.nodes.add(filterTreeNode);
        }
        if (childrenNodes == null || childrenNodes.isEmpty()) {
            return;
        }
        childrenNodes.forEach(node -> this.traverseFilterTree((ExpressionNode)node, leafUnitFlag));
    }

    private boolean isLeafUnit(List<ExpressionNode> filterTreeNodes) {
        if (filterTreeNodes == null || filterTreeNodes.isEmpty()) {
            return false;
        }
        return filterTreeNodes.stream().filter(node -> node.getKind() == ExpressionOperatorTypes.NODE_KIND.PROPERTY || node.getKind() == ExpressionOperatorTypes.NODE_KIND.LITERAL).findAny().isPresent();
    }

    public List<ExpressionNode> getNodes(Expression filterTreeNode) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<ExpressionNode>();
        }
        this.traverseFilterTree((ExpressionNode)filterTreeNode, false);
        return this.nodes;
    }

    public List<ExpressionNode> getChildren(ExpressionNode filterTreeNode) {
        ArrayList<ExpressionNode> childrenNodes = new ArrayList<ExpressionNode>();
        if (filterTreeNode instanceof BinaryExpressionNode) {
            childrenNodes.add(((BinaryExpressionNode)filterTreeNode).getFirstChild());
            childrenNodes.add(((BinaryExpressionNode)filterTreeNode).getSecondChild());
        } else if (filterTreeNode instanceof UnaryExpressionNode) {
            childrenNodes.add(((UnaryExpressionNode)filterTreeNode).getChild());
        } else if (filterTreeNode instanceof FunctionNode) {
            childrenNodes.addAll(((FunctionNode)filterTreeNode).getParameters());
        } else {
            childrenNodes = null;
        }
        return childrenNodes;
    }

    public boolean hasOperator(ExpressionNode currentNode, ExpressionOperatorTypes.OPERATOR operator) {
        if (currentNode instanceof BinaryExpressionNode) {
            return ((BinaryExpressionNode)currentNode).getOperator().equals(operator.name());
        }
        if (currentNode instanceof UnaryExpressionNode) {
            return ((UnaryExpressionNode)currentNode).getOperator().equals(operator.name());
        }
        return false;
    }

    public boolean hasFunction(ExpressionNode currentNode, ExpressionOperatorTypes.FUNCTION function) {
        if (currentNode instanceof FunctionNode) {
            return this.hasStringFunction((FunctionNode)currentNode, function);
        }
        return false;
    }

    private boolean hasStringFunction(FunctionNode currentNode, ExpressionOperatorTypes.FUNCTION function) {
        return currentNode.getFunctionName().equals(function.toString());
    }
}

